/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.RefHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.relocated.gnu.trove.TObjectHashingStrategy;

public final class WeakHashMap<K, V>
extends RefHashMap<K, V> {
    public WeakHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public WeakHashMap() {
    }

    public WeakHashMap(int initialCapacity, float loadFactor, @NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/WeakHashMap", "<init>"));
        }
        super(initialCapacity, loadFactor, strategy);
    }

    @Override
    @NotNull
    protected <T> RefHashMap.Key<T> createKey(@NotNull T k, @NotNull TObjectHashingStrategy<T> strategy, @NotNull ReferenceQueue<? super T> q) {
        if (k == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k", "com/intellij/util/containers/WeakHashMap", "createKey"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/WeakHashMap", "createKey"));
        }
        if (q == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "q", "com/intellij/util/containers/WeakHashMap", "createKey"));
        }
        WeakKey weakKey = new WeakKey(k, strategy, q);
        if (weakKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/WeakHashMap", "createKey"));
        }
        return weakKey;
    }

    private static class WeakKey<T>
    extends WeakReference<T>
    implements RefHashMap.Key<T> {
        private final int myHash;
        @NotNull
        private final TObjectHashingStrategy<T> myStrategy;

        private WeakKey(@NotNull T k, @NotNull TObjectHashingStrategy<T> strategy, @NotNull ReferenceQueue<? super T> q) {
            if (k == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k", "com/intellij/util/containers/WeakHashMap$WeakKey", "<init>"));
            }
            if (strategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/WeakHashMap$WeakKey", "<init>"));
            }
            if (q == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "q", "com/intellij/util/containers/WeakHashMap$WeakKey", "<init>"));
            }
            super(k, q);
            this.myStrategy = strategy;
            this.myHash = strategy.computeHashCode(k);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RefHashMap.Key)) {
                return false;
            }
            Object t = this.get();
            Object u = ((RefHashMap.Key)o).get();
            return RefHashMap.keyEqual(t, u, this.myStrategy);
        }

        public int hashCode() {
            return this.myHash;
        }

        @NonNls
        public String toString() {
            Object t = this.get();
            return "WeakKey(" + t + ", " + this.myHash + ")";
        }
    }
}

