/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import com.intellij.util.containers.RefHashMap;
import java.lang.ref.ReferenceQueue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.relocated.gnu.trove.TObjectHashingStrategy;

public final class SoftHashMap<K, V>
extends RefHashMap<K, V> {
    @Override
    @NotNull
    protected <T> RefHashMap.Key<T> createKey(@NotNull T k, @NotNull TObjectHashingStrategy<T> strategy, @NotNull ReferenceQueue<? super T> q) {
        if (k == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k", "com/intellij/util/containers/SoftHashMap", "createKey"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/SoftHashMap", "createKey"));
        }
        if (q == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "q", "com/intellij/util/containers/SoftHashMap", "createKey"));
        }
        SoftKey softKey = new SoftKey(k, strategy, q);
        if (softKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/SoftHashMap", "createKey"));
        }
        return softKey;
    }

    private static class SoftKey<T>
    extends SoftReference<T>
    implements RefHashMap.Key<T> {
        private final int myHash;
        @NotNull
        private final TObjectHashingStrategy<T> myStrategy;

        private SoftKey(@NotNull T k, @NotNull TObjectHashingStrategy<T> strategy, @NotNull ReferenceQueue<? super T> q) {
            if (k == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k", "com/intellij/util/containers/SoftHashMap$SoftKey", "<init>"));
            }
            if (strategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/SoftHashMap$SoftKey", "<init>"));
            }
            if (q == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "q", "com/intellij/util/containers/SoftHashMap$SoftKey", "<init>"));
            }
            super(k, q);
            this.myStrategy = strategy;
            this.myHash = strategy.computeHashCode(k);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RefHashMap.Key)) {
                return false;
            }
            if (this.myHash != o.hashCode()) {
                return false;
            }
            Object t = this.get();
            Object u = ((RefHashMap.Key)o).get();
            if (t == null || u == null) {
                return false;
            }
            return RefHashMap.keyEqual(t, u, this.myStrategy);
        }

        public int hashCode() {
            return this.myHash;
        }

        @NonNls
        public String toString() {
            return "SoftHashMap.SoftKey(" + this.get() + ")";
        }
    }
}

