/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.jetbrains.kotlin.relocated.org.apache.batik.transcoder.TranscoderException;
import org.jetbrains.kotlin.relocated.org.apache.batik.transcoder.TranscoderInput;
import org.jetbrains.kotlin.relocated.org.apache.batik.transcoder.image.ImageTranscoder;
import org.jetbrains.kotlin.relocated.org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;

public class SVGLoader {
    private TranscoderInput input;
    private BufferedImage img;
    private float width;
    private float height;

    public static Image load(@Nullable URL url, @NotNull InputStream stream2, float scale) throws IOException {
        if (stream2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/util/SVGLoader", "load"));
        }
        try {
            return new SVGLoader(url, stream2, scale).createImage();
        }
        catch (TranscoderException ex) {
            throw new IOException(ex);
        }
    }

    private SVGLoader(@Nullable URL url, InputStream stream2, float scale) throws IOException {
        Document document = null;
        String uri = null;
        try {
            uri = url != null ? url.toURI().toString() : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        document = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName()).createDocument(uri, stream2);
        if (document == null) {
            throw new IOException("document not created");
        }
        this.input = new TranscoderInput(document);
        this.width = (float)SizeAttr.width.value(document) * scale;
        this.height = (float)SizeAttr.height.value(document) * scale;
    }

    private BufferedImage createImage() throws TranscoderException {
        MyTranscoder r = new MyTranscoder();
        r.addTranscodingHint(ImageTranscoder.KEY_WIDTH, new Float(this.width));
        r.addTranscodingHint(ImageTranscoder.KEY_HEIGHT, new Float(this.height));
        r.transcode(this.input, null);
        return this.img;
    }

    private class MyTranscoder
    extends ImageTranscoder {
        private MyTranscoder() {
        }
    }

    private static final class SizeAttr
    extends Enum<SizeAttr> {
        public static final /* enum */ SizeAttr width = new SizeAttr();
        public static final /* enum */ SizeAttr height = new SizeAttr();
        private static final /* synthetic */ SizeAttr[] $VALUES;

        public static SizeAttr[] values() {
            return (SizeAttr[])$VALUES.clone();
        }

        public static SizeAttr valueOf(String name) {
            return Enum.valueOf(SizeAttr.class, name);
        }

        public int value(@NotNull Document document) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/SVGLoader$SizeAttr", "value"));
            }
            String value = document.getDocumentElement().getAttribute(this.name());
            assert (value.endsWith("px")) : "unexpected '" + this.name() + "' format in " + document.getBaseURI();
            try {
                return Integer.parseInt(value.substring(0, value.length() - 2));
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
                return 16;
            }
        }

        static {
            $VALUES = new SizeAttr[]{width, height};
        }
    }
}

