/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.ScopedClassHierarchy;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.JavaClassSupers;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClassSupersImpl
extends JavaClassSupers {
    @Override
    @Nullable
    public PsiSubstitutor getSuperClassSubstitutor(@NotNull PsiClass superClass, @NotNull PsiClass derivedClass, @NotNull GlobalSearchScope scope, @NotNull PsiSubstitutor derivedSubstitutor) {
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "com/intellij/psi/impl/JavaClassSupersImpl", "getSuperClassSubstitutor"));
        }
        if (derivedClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedClass", "com/intellij/psi/impl/JavaClassSupersImpl", "getSuperClassSubstitutor"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaClassSupersImpl", "getSuperClassSubstitutor"));
        }
        if (derivedSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedSubstitutor", "com/intellij/psi/impl/JavaClassSupersImpl", "getSuperClassSubstitutor"));
        }
        if (InheritanceImplUtil.hasObjectQualifiedName(superClass)) {
            return PsiSubstitutor.EMPTY;
        }
        if (!(derivedClass instanceof PsiTypeParameter)) {
            PsiType lowerBound;
            List<PsiType> bounds = null;
            if (superClass instanceof InferenceVariable) {
                bounds = ((InferenceVariable)superClass).getBounds(InferenceBound.LOWER);
            } else if (superClass instanceof PsiTypeParameter && (lowerBound = superClass.getUserData(InferenceSession.LOWER_BOUND)) != null) {
                bounds = Collections.singletonList(lowerBound);
            }
            if (bounds != null) {
                for (PsiType lowerBound2 : bounds) {
                    PsiSubstitutor substitutor2;
                    if (lowerBound2 == null || (substitutor2 = JavaClassSupersImpl.processLowerBound(lowerBound2, derivedClass, scope, derivedSubstitutor)) == null) continue;
                    return substitutor2;
                }
            }
        }
        return derivedClass instanceof PsiTypeParameter ? JavaClassSupersImpl.processTypeParameter((PsiTypeParameter)derivedClass, scope, superClass, ContainerUtil.<PsiTypeParameter>newTroveSet(), derivedSubstitutor) : JavaClassSupersImpl.getSuperSubstitutorWithCaching(superClass, derivedClass, scope, derivedSubstitutor);
    }

    private static PsiSubstitutor processLowerBound(@NotNull PsiType lowerBound, @NotNull PsiClass derivedClass, @NotNull GlobalSearchScope scope, @NotNull PsiSubstitutor derivedSubstitutor) {
        if (lowerBound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lowerBound", "com/intellij/psi/impl/JavaClassSupersImpl", "processLowerBound"));
        }
        if (derivedClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedClass", "com/intellij/psi/impl/JavaClassSupersImpl", "processLowerBound"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaClassSupersImpl", "processLowerBound"));
        }
        if (derivedSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedSubstitutor", "com/intellij/psi/impl/JavaClassSupersImpl", "processLowerBound"));
        }
        if (lowerBound instanceof PsiClassType) {
            PsiClassType.ClassResolveResult result2 = ((PsiClassType)lowerBound).resolveGenerics();
            PsiClass boundClass = result2.getElement();
            if (boundClass != null) {
                if (boundClass.equals(derivedClass)) {
                    return derivedSubstitutor;
                }
                PsiSubstitutor substitutor2 = JavaClassSupersImpl.getSuperSubstitutorWithCaching(boundClass, derivedClass, scope, result2.getSubstitutor());
                if (substitutor2 != null) {
                    return JavaClassSupersImpl.composeSubstitutors(derivedSubstitutor, substitutor2, boundClass);
                }
            }
        } else if (lowerBound instanceof PsiIntersectionType) {
            for (PsiType bound : ((PsiIntersectionType)lowerBound).getConjuncts()) {
                PsiSubstitutor substitutor3 = JavaClassSupersImpl.processLowerBound(bound, derivedClass, scope, derivedSubstitutor);
                if (substitutor3 == null) continue;
                return substitutor3;
            }
        }
        return null;
    }

    @Nullable
    private static PsiSubstitutor getSuperSubstitutorWithCaching(@NotNull PsiClass superClass, @NotNull PsiClass derivedClass, @NotNull GlobalSearchScope resolveScope, @NotNull PsiSubstitutor derivedSubstitutor) {
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "com/intellij/psi/impl/JavaClassSupersImpl", "getSuperSubstitutorWithCaching"));
        }
        if (derivedClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedClass", "com/intellij/psi/impl/JavaClassSupersImpl", "getSuperSubstitutorWithCaching"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "com/intellij/psi/impl/JavaClassSupersImpl", "getSuperSubstitutorWithCaching"));
        }
        if (derivedSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedSubstitutor", "com/intellij/psi/impl/JavaClassSupersImpl", "getSuperSubstitutorWithCaching"));
        }
        PsiSubstitutor substitutor2 = ScopedClassHierarchy.getSuperClassSubstitutor(derivedClass, resolveScope, superClass);
        if (substitutor2 == null) {
            return null;
        }
        if (PsiUtil.isRawSubstitutor(derivedClass, derivedSubstitutor)) {
            return JavaClassSupersImpl.createRawSubstitutor(superClass);
        }
        return JavaClassSupersImpl.composeSubstitutors(derivedSubstitutor, substitutor2, superClass);
    }

    @NotNull
    static PsiSubstitutor createRawSubstitutor(@NotNull PsiClass superClass) {
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "com/intellij/psi/impl/JavaClassSupersImpl", "createRawSubstitutor"));
        }
        PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory(superClass.getProject()).createRawSubstitutor(superClass);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaClassSupersImpl", "createRawSubstitutor"));
        }
        return psiSubstitutor;
    }

    @NotNull
    private static PsiSubstitutor composeSubstitutors(PsiSubstitutor outer, PsiSubstitutor inner, PsiClass onClass) {
        PsiSubstitutor answer = PsiSubstitutor.EMPTY;
        Map<PsiTypeParameter, PsiType> outerMap = outer.getSubstitutionMap();
        Map<PsiTypeParameter, PsiType> innerMap = inner.getSubstitutionMap();
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(onClass)) {
            if (!outerMap.containsKey(parameter) && !innerMap.containsKey(parameter)) continue;
            answer = answer.put(parameter, outer.substitute(inner.substitute(parameter)));
        }
        PsiSubstitutor psiSubstitutor = answer;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaClassSupersImpl", "composeSubstitutors"));
        }
        return psiSubstitutor;
    }

    @Nullable
    private static PsiSubstitutor processTypeParameter(PsiTypeParameter parameter, GlobalSearchScope scope, PsiClass superClass, Set<PsiTypeParameter> visited2, PsiSubstitutor derivedSubstitutor) {
        if (parameter.getManager().areElementsEquivalent(parameter, superClass)) {
            return PsiSubstitutor.EMPTY;
        }
        if (!visited2.add(parameter)) {
            return null;
        }
        for (PsiClassType type2 : parameter.getExtendsListTypes()) {
            PsiSubstitutor answer;
            PsiClassType.ClassResolveResult result2 = type2.resolveGenerics();
            PsiClass psiClass = result2.getElement();
            if (psiClass == null) continue;
            if (psiClass instanceof PsiTypeParameter) {
                answer = JavaClassSupersImpl.processTypeParameter((PsiTypeParameter)psiClass, scope, superClass, visited2, derivedSubstitutor);
                if (answer == null) continue;
                return answer;
            }
            answer = JavaClassSupersImpl.getSuperSubstitutorWithCaching(superClass, psiClass, scope, result2.getSubstitutor());
            if (answer == null) continue;
            return JavaClassSupersImpl.composeSubstitutors(derivedSubstitutor, answer, superClass);
        }
        return null;
    }
}

