/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.testng;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.testng.ISuiteListener;
import org.testng.ITestListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestNGListenerAdapterFactory {
    private final ClassLoader classLoader;

    TestNGListenerAdapterFactory(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ITestListener createAdapter(ITestListener listener) {
        Class<?> testNG6Class = this.tryLoadClass("org.testng.IConfigurationListener2");
        if (testNG6Class != null) {
            return this.createProxy(testNG6Class, listener);
        }
        Class<?> testNG5Class = this.tryLoadClass("org.testng.internal.IConfigurationListener");
        if (testNG5Class != null) {
            return this.createProxy(testNG5Class, listener);
        }
        throw new UnsupportedOperationException("Neither found interface 'org.testng.IConfigurationListener2' nor interface 'org.testng.internal.IConfigurationListener'. Which version of TestNG are you using?");
    }

    private Class<?> tryLoadClass(String name) {
        try {
            return this.classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private ITestListener createProxy(Class<?> configListenerClass, final ITestListener listener) {
        return (ITestListener)Proxy.newProxyInstance(this.classLoader, new Class[]{ITestListener.class, ISuiteListener.class, configListenerClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Class realReturnType;
                Class boxedReturnType = realReturnType = method.getReturnType();
                if (!realReturnType.equals(Void.TYPE) && realReturnType.isPrimitive()) {
                    boxedReturnType = JavaReflectionUtil.getWrapperTypeForPrimitiveType(realReturnType);
                }
                return this.invoke(listener.getClass(), listener, boxedReturnType, method, args);
            }

            private <T, R> R invoke(Class<T> listenerType, Object listener2, Class<R> returnType, Method method, Object[] args) {
                T listenerCast = listenerType.cast(listener2);
                JavaMethod javaMethod = JavaReflectionUtil.method(listenerType, returnType, (String)method.getName(), (Class[])method.getParameterTypes());
                return (R)javaMethod.invoke(listenerCast, args);
            }
        });
    }
}

