/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph;

import java.util.Arrays;
import java.util.List;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;

public class CompositeDependencyGraphVisitor
implements DependencyGraphVisitor {
    private final List<DependencyGraphVisitor> visitors;

    public CompositeDependencyGraphVisitor(DependencyGraphVisitor ... visitors) {
        this.visitors = Arrays.asList(visitors);
    }

    public void start(DependencyGraphNode root) {
        for (DependencyGraphVisitor visitor : this.visitors) {
            visitor.start(root);
        }
    }

    public void visitNode(DependencyGraphNode resolvedConfiguration) {
        for (DependencyGraphVisitor visitor : this.visitors) {
            visitor.visitNode(resolvedConfiguration);
        }
    }

    public void visitEdge(DependencyGraphNode resolvedConfiguration) {
        for (DependencyGraphVisitor visitor : this.visitors) {
            visitor.visitEdge(resolvedConfiguration);
        }
    }

    public void finish(DependencyGraphNode root) {
        for (DependencyGraphVisitor visitor : this.visitors) {
            visitor.finish(root);
        }
    }
}

