/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.gradle.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Transformer;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.buildcomparison.compare.internal.BuildComparisonResult;
import org.gradle.api.plugins.buildcomparison.compare.internal.BuildComparisonSpec;
import org.gradle.api.plugins.buildcomparison.compare.internal.BuildComparisonSpecFactory;
import org.gradle.api.plugins.buildcomparison.compare.internal.BuildOutcomeComparator;
import org.gradle.api.plugins.buildcomparison.compare.internal.BuildOutcomeComparisonResult;
import org.gradle.api.plugins.buildcomparison.compare.internal.DefaultBuildComparator;
import org.gradle.api.plugins.buildcomparison.compare.internal.DefaultBuildOutcomeComparatorFactory;
import org.gradle.api.plugins.buildcomparison.gradle.internal.ComparableGradleBuildExecuter;
import org.gradle.api.plugins.buildcomparison.gradle.internal.GradleBuildOutcomeSetInferrer;
import org.gradle.api.plugins.buildcomparison.gradle.internal.GradleBuildOutcomeSetTransformer;
import org.gradle.api.plugins.buildcomparison.outcome.internal.BuildOutcome;
import org.gradle.api.plugins.buildcomparison.outcome.internal.BuildOutcomeAssociator;
import org.gradle.api.plugins.buildcomparison.outcome.internal.ByTypeAndNameBuildOutcomeAssociator;
import org.gradle.api.plugins.buildcomparison.outcome.internal.CompositeBuildOutcomeAssociator;
import org.gradle.api.plugins.buildcomparison.render.internal.BuildComparisonResultRenderer;
import org.gradle.api.plugins.buildcomparison.render.internal.BuildOutcomeComparisonResultRenderer;
import org.gradle.api.plugins.buildcomparison.render.internal.BuildOutcomeRenderer;
import org.gradle.api.plugins.buildcomparison.render.internal.DefaultBuildOutcomeComparisonResultRendererFactory;
import org.gradle.api.plugins.buildcomparison.render.internal.DefaultBuildOutcomeRendererFactory;
import org.gradle.api.plugins.buildcomparison.render.internal.html.GradleBuildComparisonResultHtmlRenderer;
import org.gradle.api.plugins.buildcomparison.render.internal.html.HtmlRenderContext;
import org.gradle.internal.Factory;
import org.gradle.internal.IoActions;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.internal.outcomes.ProjectOutcomes;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GFileUtils;
import org.gradle.util.GradleVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradleBuildComparison {
    private static final String SOURCE_FILESTORE_PREFIX = "source";
    private static final String TARGET_FILESTORE_PREFIX = "target";
    public static final String HTML_REPORT_FILE_NAME = "index.html";
    private static final String FILES_DIR_NAME = "files";
    private final ComparableGradleBuildExecuter sourceBuildExecuter;
    private final ComparableGradleBuildExecuter targetBuildExecuter;
    private final DefaultBuildOutcomeComparatorFactory outcomeComparatorFactory = new DefaultBuildOutcomeComparatorFactory();
    private final List<BuildOutcomeAssociator> outcomeAssociators = new LinkedList<BuildOutcomeAssociator>();
    private final DefaultBuildOutcomeComparisonResultRendererFactory<HtmlRenderContext> comparisonResultRenderers = new DefaultBuildOutcomeComparisonResultRendererFactory<HtmlRenderContext>(HtmlRenderContext.class);
    private final DefaultBuildOutcomeRendererFactory<HtmlRenderContext> outcomeRenderers = new DefaultBuildOutcomeRendererFactory<HtmlRenderContext>(HtmlRenderContext.class);
    private final Logger logger;
    private final ProgressLogger progressLogger;
    private final Gradle gradle;

    public GradleBuildComparison(ComparableGradleBuildExecuter sourceBuildExecuter, ComparableGradleBuildExecuter targetBuildExecuter, Logger logger, ProgressLogger progressLogger, Gradle gradle) {
        this.sourceBuildExecuter = sourceBuildExecuter;
        this.targetBuildExecuter = targetBuildExecuter;
        this.logger = logger;
        this.progressLogger = progressLogger;
        this.gradle = gradle;
    }

    public <T extends BuildOutcome, R extends BuildOutcomeComparisonResult<T>> void registerType(Class<T> outcomeType, BuildOutcomeComparator<T, R> outcomeComparator, BuildOutcomeComparisonResultRenderer<R, HtmlRenderContext> comparisonResultRenderer, BuildOutcomeRenderer<T, HtmlRenderContext> outcomeRenderer) {
        this.outcomeComparatorFactory.registerComparator(outcomeComparator);
        this.comparisonResultRenderers.registerRenderer(comparisonResultRenderer);
        this.outcomeRenderers.registerRenderer(outcomeRenderer);
        this.outcomeAssociators.add(new ByTypeAndNameBuildOutcomeAssociator<T>(outcomeType));
    }

    private String executingMessage(String name, ComparableGradleBuildExecuter executer) {
        return String.format("executing %s build %s", name, executer.getSpec());
    }

    public BuildComparisonResult compare(FileStore<String> fileStore, File reportDir, Map<String, String> hostAttributes) {
        Set<BuildOutcome> targetOutcomes;
        String executingSourceBuildMessage = this.executingMessage(SOURCE_FILESTORE_PREFIX, this.sourceBuildExecuter);
        String executingTargetBuildMessage = this.executingMessage(TARGET_FILESTORE_PREFIX, this.targetBuildExecuter);
        if (!this.sourceBuildExecuter.isExecutable() || !this.targetBuildExecuter.isExecutable()) {
            throw new GradleException(String.format("Builds must be executed with %s or newer (source: %s, target: %s)", ComparableGradleBuildExecuter.EXEC_MINIMUM_VERSION, this.sourceBuildExecuter.getSpec().getGradleVersion(), this.targetBuildExecuter.getSpec().getGradleVersion()));
        }
        boolean sourceBuildHasOutcomesModel = this.sourceBuildExecuter.isCanObtainProjectOutcomesModel();
        boolean targetBuildHasOutcomesModel = this.targetBuildExecuter.isCanObtainProjectOutcomesModel();
        if (!sourceBuildHasOutcomesModel && !targetBuildHasOutcomesModel) {
            throw new GradleException(String.format("Cannot run comparison because both the source and target build are to be executed with a Gradle version older than %s (source: %s, target: %s).", ComparableGradleBuildExecuter.PROJECT_OUTCOMES_MINIMUM_VERSION, this.sourceBuildExecuter.getSpec().getGradleVersion(), this.targetBuildExecuter.getSpec().getGradleVersion()));
        }
        if (!sourceBuildHasOutcomesModel) {
            this.warnAboutInferredOutcomes(true, this.sourceBuildExecuter);
        }
        if (!targetBuildHasOutcomesModel) {
            this.warnAboutInferredOutcomes(false, this.targetBuildExecuter);
        }
        Set<BuildOutcome> sourceOutcomes = null;
        if (sourceBuildHasOutcomesModel) {
            this.logger.info(executingSourceBuildMessage);
            this.progressLogger.started(executingSourceBuildMessage);
            ProjectOutcomes sourceOutput = this.executeBuild(this.sourceBuildExecuter);
            this.progressLogger.progress("inspecting source build outcomes");
            GradleBuildOutcomeSetTransformer sourceOutcomeTransformer = this.createOutcomeSetTransformer(fileStore, SOURCE_FILESTORE_PREFIX);
            sourceOutcomes = sourceOutcomeTransformer.transform(sourceOutput);
        }
        this.logger.info(executingTargetBuildMessage);
        if (sourceBuildHasOutcomesModel) {
            this.progressLogger.progress(executingTargetBuildMessage);
        } else {
            this.progressLogger.started(executingTargetBuildMessage);
        }
        ProjectOutcomes targetOutput = this.executeBuild(this.targetBuildExecuter);
        if (targetBuildHasOutcomesModel) {
            this.progressLogger.progress("inspecting target build outcomes");
            GradleBuildOutcomeSetTransformer targetOutcomeTransformer = this.createOutcomeSetTransformer(fileStore, TARGET_FILESTORE_PREFIX);
            targetOutcomes = targetOutcomeTransformer.transform(targetOutput);
        } else {
            targetOutcomes = this.createOutcomeSetInferrer(fileStore, TARGET_FILESTORE_PREFIX, this.targetBuildExecuter.getSpec().getProjectDir()).transform(sourceOutcomes);
        }
        if (!sourceBuildHasOutcomesModel) {
            this.logger.info(executingSourceBuildMessage);
            this.progressLogger.progress(executingSourceBuildMessage);
            this.executeBuild(this.sourceBuildExecuter);
            this.progressLogger.progress("inspecting source build outcomes");
            sourceOutcomes = this.createOutcomeSetInferrer(fileStore, SOURCE_FILESTORE_PREFIX, this.sourceBuildExecuter.getSpec().getProjectDir()).transform(targetOutcomes);
        }
        this.progressLogger.progress("comparing build outcomes");
        BuildComparisonResult result = this.compareBuilds(sourceOutcomes, targetOutcomes);
        this.writeReport(result, reportDir, fileStore, hostAttributes);
        this.progressLogger.completed();
        return result;
    }

    private void warnAboutInferredOutcomes(boolean isSource, ComparableGradleBuildExecuter executer) {
        String inferred = isSource ? SOURCE_FILESTORE_PREFIX : TARGET_FILESTORE_PREFIX;
        String inferredFrom = isSource ? TARGET_FILESTORE_PREFIX : SOURCE_FILESTORE_PREFIX;
        String message = String.format("The build outcomes for the %s build will be inferred from the %s build because the %s build is to be executed with Gradle %s. This means that the comparison accuracy will be reduced. See the Gradle User Guide for more information.", inferred, inferredFrom, inferred, executer.getSpec().getGradleVersion());
        this.logger.warn(message);
    }

    private BuildComparisonResult compareBuilds(Set<BuildOutcome> sourceOutcomes, Set<BuildOutcome> targetOutcomes) {
        BuildComparisonSpecFactory specFactory = new BuildComparisonSpecFactory(this.createBuildOutcomeAssociator());
        BuildComparisonSpec comparisonSpec = specFactory.createSpec(sourceOutcomes, targetOutcomes);
        DefaultBuildComparator buildComparator = new DefaultBuildComparator(this.outcomeComparatorFactory);
        return buildComparator.compareBuilds(comparisonSpec);
    }

    private CompositeBuildOutcomeAssociator createBuildOutcomeAssociator() {
        return new CompositeBuildOutcomeAssociator(this.outcomeAssociators);
    }

    private GradleBuildOutcomeSetTransformer createOutcomeSetTransformer(FileStore<String> fileStore, String filesPath) {
        return new GradleBuildOutcomeSetTransformer(fileStore, filesPath);
    }

    private GradleBuildOutcomeSetInferrer createOutcomeSetInferrer(FileStore<String> fileStore, String filesPath, File baseDir) {
        return new GradleBuildOutcomeSetInferrer(fileStore, filesPath, baseDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectOutcomes executeBuild(ComparableGradleBuildExecuter executer) {
        ProjectConnection connection = this.createProjectConnection(executer);
        try {
            ProjectOutcomes projectOutcomes = executer.executeWith(connection);
            return projectOutcomes;
        }
        finally {
            connection.close();
        }
    }

    private ProjectConnection createProjectConnection(ComparableGradleBuildExecuter executer) {
        GradleVersion gradleVersion;
        GradleConnector connector = (GradleConnector)DeprecationLogger.whileDisabled((Factory)new Factory<GradleConnector>(){

            public GradleConnector create() {
                return GradleConnector.newConnector();
            }
        });
        connector.forProjectDirectory(executer.getSpec().getProjectDir());
        File gradleUserHomeDir = this.gradle.getStartParameter().getGradleUserHomeDir();
        if (gradleUserHomeDir != null) {
            connector.useGradleUserHomeDir(gradleUserHomeDir);
        }
        if ((gradleVersion = executer.getGradleVersion()).equals((Object)GradleVersion.current())) {
            connector.useInstallation(this.gradle.getGradleHomeDir());
        } else {
            connector.useGradleVersion(gradleVersion.getVersion());
        }
        return connector.connect();
    }

    private void writeReport(final BuildComparisonResult result, final File reportDir, FileStore<String> fileStore, final Map<String, String> hostAttributes) {
        if (reportDir.exists() && reportDir.list().length > 0) {
            GFileUtils.cleanDirectory((File)reportDir);
        }
        fileStore.moveFilestore(new File(reportDir, FILES_DIR_NAME));
        final Charset encoding = Charset.defaultCharset();
        IoActions.writeTextFile((File)new File(reportDir, HTML_REPORT_FILE_NAME), (String)encoding.name(), (Action)new Action<BufferedWriter>(){

            public void execute(BufferedWriter writer) {
                GradleBuildComparison.this.createResultRenderer(encoding, reportDir, hostAttributes).render(result, writer);
            }
        });
    }

    private BuildComparisonResultRenderer<Writer> createResultRenderer(Charset encoding, final File reportDir, Map<String, String> hostAttributes) {
        return new GradleBuildComparisonResultHtmlRenderer(this.comparisonResultRenderers, this.outcomeRenderers, encoding, this.sourceBuildExecuter, this.targetBuildExecuter, hostAttributes, new Transformer<String, File>(){

            public String transform(File original) {
                return GFileUtils.relativePath((File)reportDir, (File)original);
            }
        });
    }
}

