/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DirSnapshot;
import org.gradle.api.internal.changedetection.state.FileHashSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshotWithKey;
import org.gradle.api.internal.changedetection.state.FileSnapshotter;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshot;
import org.gradle.api.internal.changedetection.state.MissingFileSnapshot;
import org.gradle.api.internal.changedetection.state.TreeSnapshot;
import org.gradle.api.internal.changedetection.state.VisitedTree;
import org.gradle.api.internal.file.FileTreeElementHasher;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultVisitedTree
implements VisitedTree {
    private final String absolutePath;
    private final PatternSet patternSet;
    private final boolean shareable;
    private final long nextId;
    private final List<FileTreeElement> entries;
    private final Collection<File> missingFiles;
    private TreeSnapshot treeSnapshot;
    private Integer preCheckHash;

    public DefaultVisitedTree(String absolutePath, PatternSet patternSet, List<FileTreeElement> entries, boolean shareable, long nextId, Collection<File> missingFiles) {
        this.absolutePath = absolutePath;
        this.patternSet = patternSet;
        this.shareable = shareable;
        this.nextId = nextId;
        this.entries = entries;
        this.missingFiles = missingFiles;
    }

    @Override
    public String getAbsolutePath() {
        return this.absolutePath;
    }

    @Override
    public PatternSet getPatternSet() {
        return this.patternSet;
    }

    @Override
    public Collection<FileTreeElement> getEntries() {
        return this.entries;
    }

    @Override
    public List<FileTreeElement> filter(PatternSet patternSet) {
        ImmutableList.Builder filtered = ImmutableList.builder();
        Spec<FileTreeElement> spec = patternSet.getAsSpec();
        for (FileTreeElement element : this.entries) {
            if (!spec.isSatisfiedBy((Object)element)) continue;
            filtered.add((Object)element);
        }
        return filtered.build();
    }

    @Override
    public synchronized int calculatePreCheckHash() {
        if (this.preCheckHash == null) {
            this.preCheckHash = FileTreeElementHasher.calculateHashForFileMetadata(this.entries);
        }
        return this.preCheckHash;
    }

    @Override
    public synchronized TreeSnapshot maybeCreateSnapshot(FileSnapshotter fileSnapshotter, StringInterner stringInterner) {
        if (this.treeSnapshot == null) {
            this.treeSnapshot = this.createTreeSnapshot(fileSnapshotter, stringInterner);
        }
        return this.treeSnapshot;
    }

    private TreeSnapshot createTreeSnapshot(final FileSnapshotter fileSnapshotter, final StringInterner stringInterner) {
        List fileSnapshots = CollectionUtils.collect(this.getEntries(), (Transformer)new Transformer<FileSnapshotWithKey, FileTreeElement>(){

            public FileSnapshotWithKey transform(FileTreeElement fileTreeElement) {
                String absolutePath = DefaultVisitedTree.this.getInternedAbsolutePath(fileTreeElement.getFile(), stringInterner);
                IncrementalFileSnapshot incrementalFileSnapshot = fileTreeElement.isDirectory() ? DirSnapshot.getInstance() : new FileHashSnapshot(fileSnapshotter.snapshot(fileTreeElement).getHash(), fileTreeElement.getLastModified());
                return new FileSnapshotWithKey(absolutePath, incrementalFileSnapshot);
            }
        });
        if (this.missingFiles != null) {
            for (File file : this.missingFiles) {
                fileSnapshots.add(new FileSnapshotWithKey(this.getInternedAbsolutePath(file, stringInterner), MissingFileSnapshot.getInstance()));
            }
        }
        return new DefaultTreeSnapshot(fileSnapshots, this.shareable, this.nextId);
    }

    private String getInternedAbsolutePath(File file, StringInterner stringInterner) {
        return stringInterner.intern(file.getAbsolutePath());
    }

    @Override
    public boolean isShareable() {
        return this.shareable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class VisitedTreeComparator
    implements Comparator<VisitedTree> {
        public static final VisitedTreeComparator INSTANCE = new VisitedTreeComparator();

        private VisitedTreeComparator() {
        }

        @Override
        public int compare(VisitedTree o1, VisitedTree o2) {
            CompareToBuilder compareToBuilder = new CompareToBuilder();
            compareToBuilder.append((Object)o1.getAbsolutePath(), (Object)o2.getAbsolutePath());
            if (compareToBuilder.toComparison() != 0) {
                return compareToBuilder.toComparison();
            }
            compareToBuilder.append(o1.getPatternSet() != null ? o1.getPatternSet().hashCode() : 0, o2.getPatternSet() != null ? o2.getPatternSet().hashCode() : 0);
            if (compareToBuilder.toComparison() != 0) {
                return compareToBuilder.toComparison();
            }
            compareToBuilder.append(o1.hashCode(), o2.hashCode());
            return compareToBuilder.toComparison();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultTreeSnapshot
    implements TreeSnapshot {
        private final Collection<FileSnapshotWithKey> fileSnapshots;
        private final boolean shareable;
        private final long nextId;
        private Long assignedId;

        public DefaultTreeSnapshot(Collection<FileSnapshotWithKey> fileSnapshots, boolean shareable, long nextId) {
            this.fileSnapshots = fileSnapshots;
            this.shareable = shareable;
            this.nextId = nextId;
        }

        @Override
        public boolean isShareable() {
            return this.shareable;
        }

        @Override
        public Collection<FileSnapshotWithKey> getFileSnapshots() {
            return this.fileSnapshots;
        }

        @Override
        public Long getAssignedId() {
            return this.assignedId;
        }

        @Override
        public synchronized Long maybeStoreEntry(Action<Long> storeEntryAction) {
            if (this.assignedId == null) {
                this.assignedId = this.nextId;
                storeEntryAction.execute((Object)this.assignedId);
            }
            return this.assignedId;
        }
    }
}

