/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import java.util.Map;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotData;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashValueSerializer;
import org.gradle.internal.serialize.MapSerializer;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarSnapshotDataSerializer
implements Serializer<JarSnapshotData> {
    private final MapSerializer<String, HashValue> mapSerializer;
    private final Serializer<ClassSetAnalysisData> analysisSerializer;
    private final HashValueSerializer hashValueSerializer = new HashValueSerializer();

    public JarSnapshotDataSerializer() {
        this.mapSerializer = new MapSerializer(BaseSerializerFactory.STRING_SERIALIZER, (Serializer)this.hashValueSerializer);
        this.analysisSerializer = new ClassSetAnalysisData.Serializer();
    }

    public JarSnapshotData read(Decoder decoder) throws Exception {
        HashValue hash = this.hashValueSerializer.read(decoder);
        Map hashes = this.mapSerializer.read(decoder);
        ClassSetAnalysisData data = (ClassSetAnalysisData)this.analysisSerializer.read(decoder);
        return new JarSnapshotData(hash, hashes, data);
    }

    public void write(Encoder encoder, JarSnapshotData value) throws Exception {
        this.hashValueSerializer.write(encoder, value.hash);
        this.mapSerializer.write(encoder, value.hashes);
        this.analysisSerializer.write(encoder, (Object)value.data);
    }
}

