/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import org.gradle.api.JavaVersion;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerFactory;
import org.gradle.api.tasks.javadoc.internal.JavadocGenerator;
import org.gradle.api.tasks.javadoc.internal.JavadocSpec;
import org.gradle.jvm.internal.toolchain.JavaToolChainInternal;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.platform.base.internal.toolchain.ToolProvider;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.util.TreeVisitor;

public class DefaultJavaToolChain
implements JavaToolChainInternal {
    private final JavaCompilerFactory compilerFactory;
    private final ExecActionFactory execActionFactory;
    private final JavaVersion javaVersion;

    public DefaultJavaToolChain(JavaCompilerFactory compilerFactory, ExecActionFactory execActionFactory) {
        this.compilerFactory = compilerFactory;
        this.execActionFactory = execActionFactory;
        this.javaVersion = JavaVersion.current();
    }

    public String getName() {
        return "JDK" + this.javaVersion;
    }

    public String getDisplayName() {
        return "JDK " + this.javaVersion.getMajorVersion() + " (" + this.javaVersion + ")";
    }

    public String toString() {
        return this.getDisplayName();
    }

    public ToolProvider select(JavaPlatform targetPlatform) {
        if (targetPlatform != null && targetPlatform.getTargetCompatibility().compareTo((Enum)this.javaVersion) > 0) {
            return new UnavailableToolProvider(targetPlatform);
        }
        return new JavaToolProvider();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnavailableToolProvider
    implements ToolProvider {
        private final JavaPlatform targetPlatform;

        private UnavailableToolProvider(JavaPlatform targetPlatform) {
            this.targetPlatform = targetPlatform;
        }

        public <T extends CompileSpec> Compiler<T> newCompiler(Class<T> spec) {
            throw new IllegalArgumentException(this.getMessage());
        }

        public <T> T get(Class<T> toolType) {
            throw new IllegalArgumentException(this.getMessage());
        }

        public boolean isAvailable() {
            return false;
        }

        public void explain(TreeVisitor<? super String> visitor) {
            visitor.node((Object)this.getMessage());
        }

        private String getMessage() {
            return String.format("Could not target platform: '%s' using tool chain: '%s'.", this.targetPlatform.getDisplayName(), DefaultJavaToolChain.this.getDisplayName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JavaToolProvider
    implements ToolProvider {
        private JavaToolProvider() {
        }

        public <T extends CompileSpec> Compiler<T> newCompiler(Class<T> spec) {
            if (JavaCompileSpec.class.isAssignableFrom(spec)) {
                Compiler<JavaCompileSpec> compiler = DefaultJavaToolChain.this.compilerFactory.create(spec);
                return compiler;
            }
            if (JavadocSpec.class.isAssignableFrom(spec)) {
                JavadocGenerator compiler = new JavadocGenerator(DefaultJavaToolChain.this.execActionFactory);
                return compiler;
            }
            throw new IllegalArgumentException(String.format("Don't know how to compile using spec of type %s.", spec.getClass().getSimpleName()));
        }

        public <T> T get(Class<T> toolType) {
            throw new IllegalArgumentException(String.format("Don't know how to provide tool of type %s.", toolType.getSimpleName()));
        }

        public boolean isAvailable() {
            return true;
        }

        public void explain(TreeVisitor<? super String> visitor) {
        }
    }
}

