/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.jarjar.org.gradle.internal.exceptions;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.gradle.testkit.jarjar.org.gradle.api.GradleException;
import org.gradle.testkit.jarjar.org.gradle.internal.exceptions.MultiCauseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMultiCauseException
extends GradleException
implements MultiCauseException {
    private final List<Throwable> causes = new CopyOnWriteArrayList<Throwable>();
    private transient ThreadLocal<Boolean> hideCause = this.threadLocal();

    public DefaultMultiCauseException(String message) {
        super(message);
    }

    public DefaultMultiCauseException(String message, Throwable ... causes) {
        super(message);
        this.causes.addAll(Arrays.asList(causes));
    }

    public DefaultMultiCauseException(String message, Iterable<? extends Throwable> causes) {
        super(message);
        this.initCauses(causes);
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        this.hideCause = this.threadLocal();
    }

    private ThreadLocal<Boolean> threadLocal() {
        return new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
    }

    @Override
    public List<? extends Throwable> getCauses() {
        return this.causes;
    }

    @Override
    public Throwable initCause(Throwable throwable) {
        this.causes.clear();
        this.causes.add(throwable);
        return null;
    }

    public void initCauses(Iterable<? extends Throwable> causes) {
        this.causes.clear();
        for (Throwable throwable : causes) {
            this.causes.add(throwable);
        }
    }

    @Override
    public Throwable getCause() {
        if (this.hideCause.get().booleanValue()) {
            return null;
        }
        return this.causes.isEmpty() ? null : this.causes.get(0);
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        PrintWriter writer = new PrintWriter(printStream);
        this.printStackTrace(writer);
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter printWriter) {
        if (this.causes.size() <= 1) {
            super.printStackTrace(printWriter);
            return;
        }
        this.hideCause.set(true);
        try {
            super.printStackTrace(printWriter);
            for (int i = 0; i < this.causes.size(); ++i) {
                Throwable cause = this.causes.get(i);
                printWriter.format("Cause %s: ", i + 1);
                cause.printStackTrace(printWriter);
            }
            Object var5_4 = null;
            this.hideCause.set(false);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.hideCause.set(false);
            throw throwable;
        }
    }
}

