/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.resolve;

import java.util.Set;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.InvalidUserDataException;
import org.gradle.language.base.internal.resolve.LibraryResolveException;
import org.gradle.nativeplatform.BuildType;
import org.gradle.nativeplatform.Flavor;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeDependencySet;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.NativeLibraryRequirement;
import org.gradle.nativeplatform.SharedLibraryBinary;
import org.gradle.nativeplatform.StaticLibraryBinary;
import org.gradle.nativeplatform.internal.resolve.DefaultNativeDependencySet;
import org.gradle.nativeplatform.internal.resolve.LibraryBinaryLocator;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.util.GUtil;

class DefaultLibraryResolver {
    private final NativeLibraryRequirement requirement;
    private final NativeBinarySpec context;
    private final LibraryBinaryLocator libraryBinaryLocator;

    public DefaultLibraryResolver(LibraryBinaryLocator libraryBinaryLocator, NativeLibraryRequirement requirement, NativeBinarySpec context) {
        this.requirement = requirement;
        this.context = context;
        this.libraryBinaryLocator = libraryBinaryLocator;
    }

    public NativeLibraryBinary resolveLibraryBinary() {
        DomainObjectSet<NativeLibraryBinary> binaries = this.libraryBinaryLocator.getBinaries(this.requirement);
        if (binaries == null) {
            throw new LibraryResolveException(this.getFailureMessage(this.requirement));
        }
        return new LibraryResolution().withFlavor(this.context.getFlavor()).withPlatform(this.context.getTargetPlatform()).withBuildType(this.context.getBuildType()).resolveLibrary(binaries);
    }

    private String getFailureMessage(NativeLibraryRequirement requirement) {
        return requirement.getProjectPath() == null ? String.format("Could not locate library '%s'.", requirement.getLibraryName()) : String.format("Could not locate library '%s' for project '%s'.", requirement.getLibraryName(), requirement.getProjectPath());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LibraryResolution {
        private Flavor flavor;
        private NativePlatform platform;
        private BuildType buildType;

        private LibraryResolution() {
        }

        public LibraryResolution withFlavor(Flavor flavor) {
            this.flavor = flavor;
            return this;
        }

        public LibraryResolution withPlatform(NativePlatform platform) {
            this.platform = platform;
            return this;
        }

        public LibraryResolution withBuildType(BuildType buildType) {
            this.buildType = buildType;
            return this;
        }

        public NativeDependencySet resolve(DomainObjectSet<NativeLibraryBinary> allBinaries) {
            NativeLibraryBinary resolve = this.resolveLibrary(allBinaries);
            return new DefaultNativeDependencySet(resolve);
        }

        public NativeLibraryBinary resolveLibrary(DomainObjectSet<NativeLibraryBinary> allBinaries) {
            Class<? extends NativeLibraryBinary> type = this.getTypeForLinkage(DefaultLibraryResolver.this.requirement.getLinkage());
            DomainObjectSet candidateBinaries = allBinaries.withType(type);
            return this.resolve((Set<? extends NativeLibraryBinary>)candidateBinaries);
        }

        private Class<? extends NativeLibraryBinary> getTypeForLinkage(String linkage) {
            if ("static".equals(linkage)) {
                return StaticLibraryBinary.class;
            }
            if ("shared".equals(linkage) || linkage == null) {
                return SharedLibraryBinary.class;
            }
            throw new InvalidUserDataException("Not a valid linkage: " + linkage);
        }

        private NativeLibraryBinary resolve(Set<? extends NativeLibraryBinary> candidates) {
            for (NativeLibraryBinary nativeLibraryBinary : candidates) {
                if (this.flavor != null && !this.flavor.getName().equals(nativeLibraryBinary.getFlavor().getName()) || this.platform != null && !this.platform.getName().equals(nativeLibraryBinary.getTargetPlatform().getName()) || this.buildType != null && !this.buildType.getName().equals(nativeLibraryBinary.getBuildType().getName())) continue;
                return nativeLibraryBinary;
            }
            String typeName = (String)GUtil.elvis((Object)DefaultLibraryResolver.this.requirement.getLinkage(), (Object)"shared");
            throw new LibraryResolveException(String.format("No %s library binary available for library '%s' with [flavor: '%s', platform: '%s', buildType: '%s']", typeName, DefaultLibraryResolver.this.requirement.getLibraryName(), this.flavor.getName(), this.platform.getName(), this.buildType.getName()));
        }
    }
}

