/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.Collections;
import org.gradle.api.execution.internal.InternalTaskExecutionListener;
import org.gradle.api.execution.internal.TaskOperationInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.progress.OperationResult;
import org.gradle.internal.progress.OperationStartEvent;
import org.gradle.tooling.internal.provider.BuildClientSubscriptions;
import org.gradle.tooling.internal.provider.events.AbstractTaskResult;
import org.gradle.tooling.internal.provider.events.DefaultFailure;
import org.gradle.tooling.internal.provider.events.DefaultTaskDescriptor;
import org.gradle.tooling.internal.provider.events.DefaultTaskFailureResult;
import org.gradle.tooling.internal.provider.events.DefaultTaskFinishedProgressEvent;
import org.gradle.tooling.internal.provider.events.DefaultTaskSkippedResult;
import org.gradle.tooling.internal.provider.events.DefaultTaskStartedProgressEvent;
import org.gradle.tooling.internal.provider.events.DefaultTaskSuccessResult;

class ClientForwardingTaskListener
implements InternalTaskExecutionListener {
    private final BuildEventConsumer eventConsumer;
    private final BuildClientSubscriptions clientSubscriptions;

    ClientForwardingTaskListener(BuildEventConsumer eventConsumer, BuildClientSubscriptions clientSubscriptions) {
        this.eventConsumer = eventConsumer;
        this.clientSubscriptions = clientSubscriptions;
    }

    public void beforeExecute(TaskOperationInternal taskOperation, OperationStartEvent startEvent) {
        this.eventConsumer.dispatch((Object)new DefaultTaskStartedProgressEvent(startEvent.getStartTime(), this.toTaskDescriptor(taskOperation)));
    }

    public void afterExecute(TaskOperationInternal taskOperation, OperationResult result) {
        this.eventConsumer.dispatch((Object)new DefaultTaskFinishedProgressEvent(result.getEndTime(), this.toTaskDescriptor(taskOperation), ClientForwardingTaskListener.toTaskResult(taskOperation.getTask(), result)));
    }

    private DefaultTaskDescriptor toTaskDescriptor(TaskOperationInternal taskOperation) {
        TaskInternal task = taskOperation.getTask();
        Object id = taskOperation.getId();
        String displayName = String.format("Task %s", task.getPath());
        String taskPath = task.getPath();
        Object parentId = this.getParentId(taskOperation);
        return new DefaultTaskDescriptor(id, taskPath, displayName, parentId);
    }

    private Object getParentId(TaskOperationInternal taskOperation) {
        return this.clientSubscriptions.isSendBuildProgressEvents() ? taskOperation.getParentId() : null;
    }

    private static AbstractTaskResult toTaskResult(TaskInternal task, OperationResult result) {
        TaskStateInternal state = task.getState();
        long startTime = result.getStartTime();
        long endTime = result.getEndTime();
        if (state.getUpToDate()) {
            return new DefaultTaskSuccessResult(startTime, endTime, true);
        }
        if (state.getSkipped()) {
            return new DefaultTaskSkippedResult(startTime, endTime, state.getSkipMessage());
        }
        Throwable failure = state.getFailure();
        if (failure == null) {
            return new DefaultTaskSuccessResult(startTime, endTime, false);
        }
        return new DefaultTaskFailureResult(startTime, endTime, Collections.singletonList(DefaultFailure.fromThrowable((Throwable)failure)));
    }
}

