/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive.compression;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.gradle.api.internal.file.archive.compression.AbstractArchiver;
import org.gradle.api.internal.file.archive.compression.ArchiveOutputStreamFactory;
import org.gradle.api.resources.ResourceException;
import org.gradle.api.resources.internal.ReadableResourceInternal;

public class GzipArchiver
extends AbstractArchiver {
    public GzipArchiver(ReadableResourceInternal resource) {
        super(resource);
    }

    protected String getSchemePrefix() {
        return "gzip:";
    }

    public static ArchiveOutputStreamFactory getCompressor() {
        return new ArchiveOutputStreamFactory(){

            public OutputStream createArchiveOutputStream(File destination) {
                try {
                    FileOutputStream outStr = new FileOutputStream(destination);
                    return new GZIPOutputStream(outStr);
                }
                catch (Exception e) {
                    String message = String.format("Unable to create gzip output stream for file %s.", destination);
                    throw new RuntimeException(message, e);
                }
            }
        };
    }

    public InputStream read() {
        InputStream is = this.resource.read();
        try {
            return new GZIPInputStream(is);
        }
        catch (Exception e) {
            String message = String.format("Unable to create gzip input stream for resource %s.", this.resource.getDisplayName());
            throw new ResourceException(message, e);
        }
    }
}

