/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;
import org.gradle.cache.Cache;
import org.gradle.internal.Deferrable;
import org.gradle.internal.Try;
import org.gradle.internal.execution.DeferredResult;
import org.gradle.internal.execution.Identity;
import org.gradle.internal.execution.ImplementationVisitor;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.steps.BuildOperationStep;
import org.gradle.internal.execution.steps.DeferredExecutionAwareStep;
import org.gradle.internal.execution.steps.ExecutionRequestContext;
import org.gradle.internal.execution.steps.IdentityContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifyStep<C extends ExecutionRequestContext, R extends Result>
extends BuildOperationStep<C, R>
implements DeferredExecutionAwareStep<C, R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifyStep.class);
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final DeferredExecutionAwareStep<? super IdentityContext, R> delegate;

    public IdentifyStep(BuildOperationRunner buildOperationRunner, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, DeferredExecutionAwareStep<? super IdentityContext, R> delegate) {
        super(buildOperationRunner);
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, C context) {
        return this.delegate.execute(work, this.createIdentityContext(work, context));
    }

    @Override
    public <T> Deferrable<Try<T>> executeDeferred(UnitOfWork work, C context, Cache<Identity, DeferredResult<T>> cache) {
        return this.delegate.executeDeferred(work, this.createIdentityContext(work, context), cache);
    }

    private IdentityContext createIdentityContext(UnitOfWork work, C context) {
        ImplementationsBuilder implementationsBuilder = new ImplementationsBuilder(this.classLoaderHierarchyHasher);
        work.visitImplementations(implementationsBuilder);
        ImplementationSnapshot implementation = implementationsBuilder.getImplementation();
        ImmutableList<ImplementationSnapshot> additionalImplementations = implementationsBuilder.getAdditionalImplementations();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Implementation for {}: {}", (Object)work.getDisplayName(), (Object)implementation);
            LOGGER.debug("Additional implementations for {}: {}", (Object)work.getDisplayName(), additionalImplementations);
        }
        InputFingerprinter.Result inputs = work.getInputFingerprinter().fingerprintInputProperties((ImmutableSortedMap<String, ValueSnapshot>)ImmutableSortedMap.of(), (ImmutableSortedMap<String, ? extends FileCollectionFingerprint>)ImmutableSortedMap.of(), (ImmutableSortedMap<String, ValueSnapshot>)ImmutableSortedMap.of(), (ImmutableSortedMap<String, CurrentFileCollectionFingerprint>)ImmutableSortedMap.of(), work::visitImmutableInputs, work.getInputDependencyChecker(((ExecutionRequestContext)context).getValidationContext()));
        ImmutableSortedMap<String, ValueSnapshot> scalarInputProperties = inputs.getValueSnapshots();
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> fileInputProperties = inputs.getFileFingerprints();
        Identity identity = work.identify((Map<String, ValueSnapshot>)scalarInputProperties, (Map<String, CurrentFileCollectionFingerprint>)fileInputProperties);
        return new IdentityContext((ExecutionRequestContext)context, implementation, additionalImplementations, scalarInputProperties, fileInputProperties, identity);
    }

    private static class ImplementationsBuilder
    implements ImplementationVisitor {
        private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
        private @Nullable ImplementationSnapshot implementation;
        private final ImmutableList.Builder<ImplementationSnapshot> additionalImplementations = ImmutableList.builder();

        public ImplementationsBuilder(ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
            this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        }

        @Override
        public void visitImplementation(Class<?> implementation) {
            this.implementation = ImplementationSnapshot.of(implementation, (ClassLoaderHierarchyHasher)this.classLoaderHierarchyHasher);
        }

        @Override
        public void visitAdditionalImplementation(ImplementationSnapshot implementation) {
            this.additionalImplementations.add((Object)implementation);
        }

        public ImplementationSnapshot getImplementation() {
            if (this.implementation == null) {
                throw new IllegalStateException("No implementation is set");
            }
            return this.implementation;
        }

        public ImmutableList<ImplementationSnapshot> getAdditionalImplementations() {
            return this.additionalImplementations.build();
        }
    }
}

