/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import java.io.Closeable;
import java.util.function.Function;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.caching.internal.controller.impl.LifecycleAwareBuildCacheController;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildModelControllerServices;
import org.gradle.internal.build.BuildProjectRegistry;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildToolingModelController;
import org.gradle.internal.build.BuildWorkGraphController;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.service.CloseableServiceRegistry;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.internal.service.scopes.Scope;
import org.jspecify.annotations.Nullable;

public abstract class AbstractBuildState
implements BuildState,
Closeable {
    private final @Nullable BuildState parent;
    private final CloseableServiceRegistry buildServices;
    private final Lazy<BuildLifecycleController> buildLifecycleController;
    private final Lazy<ProjectStateRegistry> projectStateRegistry;
    private final Lazy<BuildWorkGraphController> workGraphController;

    public AbstractBuildState(BuildTreeState buildTree, BuildDefinition buildDefinition, @Nullable BuildState parent) {
        this.parent = parent;
        BuildModelControllerServices buildModelControllerServices = (BuildModelControllerServices)buildTree.getServices().get(BuildModelControllerServices.class);
        BuildModelControllerServices.Supplier supplier = buildModelControllerServices.servicesForBuild(buildDefinition, this);
        this.buildServices = this.prepareServices(buildTree, buildDefinition, supplier);
        this.buildLifecycleController = Lazy.locking().of(() -> (BuildLifecycleController)this.buildServices.get(BuildLifecycleController.class));
        this.projectStateRegistry = Lazy.locking().of(() -> (ProjectStateRegistry)this.buildServices.get(ProjectStateRegistry.class));
        this.workGraphController = Lazy.locking().of(() -> (BuildWorkGraphController)this.buildServices.get(BuildWorkGraphController.class));
    }

    private CloseableServiceRegistry prepareServices(BuildTreeState buildTree, BuildDefinition buildDefinition, BuildModelControllerServices.Supplier supplier) {
        return ServiceRegistryBuilder.builder().displayName("Build-scoped services").scopeStrictly(Scope.Build.class).parent(buildTree.getServices()).provider(this.prepareServicesProvider(buildDefinition, supplier)).build();
    }

    @Override
    public @Nullable BuildState getParent() {
        return this.parent;
    }

    protected ServiceRegistrationProvider prepareServicesProvider(BuildDefinition buildDefinition, BuildModelControllerServices.Supplier supplier) {
        return new BuildScopeServices(supplier);
    }

    protected CloseableServiceRegistry getBuildServices() {
        return this.buildServices;
    }

    @Override
    public void close() {
        this.buildServices.close();
    }

    @Override
    public DisplayName getDisplayName() {
        return Describables.of((Object)this.getBuildIdentifier());
    }

    public String toString() {
        return this.getDisplayName().getDisplayName();
    }

    @Override
    public void resetModel() {
        ((ProjectStateRegistry)this.projectStateRegistry.get()).discardProjectsFor(this);
        ((BuildWorkGraphController)this.workGraphController.get()).resetState();
        ((BuildLifecycleController)this.buildLifecycleController.get()).resetModel();
        ((LifecycleAwareBuildCacheController)((BuildLifecycleController)this.buildLifecycleController.get()).getGradle().getServices().get(LifecycleAwareBuildCacheController.class)).resetState();
    }

    @Override
    public ExecutionResult<Void> beforeModelReset() {
        return this.getBuildController().beforeModelReset();
    }

    @Override
    public ExecutionResult<Void> beforeModelDiscarded(boolean failed) {
        return this.getBuildController().beforeModelDiscarded(failed);
    }

    @Override
    public void assertCanAdd(IncludedBuildSpec includedBuildSpec) {
        throw new UnsupportedOperationException("Cannot include build '" + includedBuildSpec.rootDir.getName() + "' in " + this.getBuildIdentifier() + ". This is not supported yet.");
    }

    @Override
    public boolean isImportableBuild() {
        return true;
    }

    protected ProjectStateRegistry getProjectStateRegistry() {
        return (ProjectStateRegistry)this.projectStateRegistry.get();
    }

    @Override
    public BuildProjectRegistry getProjects() {
        return this.getProjectStateRegistry().projectsFor(this.getBuildIdentifier());
    }

    protected BuildLifecycleController getBuildController() {
        return (BuildLifecycleController)this.buildLifecycleController.get();
    }

    @Override
    public void ensureProjectsLoaded() {
        this.getBuildController().loadSettings();
    }

    @Override
    public boolean isProjectsLoaded() {
        return this.getProjectStateRegistry().findProjectsFor(this.getBuildIdentifier()) != null;
    }

    @Override
    public boolean isProjectsCreated() {
        BuildProjectRegistry projectsForThisBuild = this.getProjectStateRegistry().findProjectsFor(this.getBuildIdentifier());
        return projectsForThisBuild != null && projectsForThisBuild.getRootProject().isCreated();
    }

    @Override
    public void ensureProjectsConfigured() {
        this.getBuildController().configureProjects();
    }

    @Override
    public GradleInternal getMutableModel() {
        return this.getBuildController().getGradle();
    }

    @Override
    public BuildWorkGraphController getWorkGraph() {
        return (BuildWorkGraphController)this.workGraphController.get();
    }

    @Override
    public <T> T withToolingModels(boolean inResilientContext, Function<? super BuildToolingModelController, T> action) {
        return this.getBuildController().withToolingModels(inResilientContext, action);
    }
}

