/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results.serializable;

import java.io.IOException;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public final class OutputRanges {
    public static final Serializer<OutputRanges> SERIALIZER = new Serializer<OutputRanges>(){
        private static final byte DESTINATION_STDOUT = 1;
        private static final byte DESTINATION_STDERR = 2;

        public OutputRanges read(Decoder decoder) throws IOException {
            byte destinations = decoder.readByte();
            long startStdout = -1L;
            long startStderr = -1L;
            long end = -1L;
            if ((destinations & 1) != 0) {
                startStdout = decoder.readSmallLong();
            }
            if ((destinations & 2) != 0) {
                startStderr = decoder.readSmallLong();
            }
            if (destinations != 0) {
                end = decoder.readSmallLong();
            }
            return OutputRanges.of(startStdout, startStderr, end);
        }

        public void write(Encoder encoder, OutputRanges value) throws IOException {
            byte destinations = 0;
            if (value.startStdout != -1L) {
                destinations = (byte)(destinations | 1);
            }
            if (value.startStderr != -1L) {
                destinations = (byte)(destinations | 2);
            }
            encoder.writeByte(destinations);
            if (value.startStdout != -1L) {
                encoder.writeSmallLong(value.startStdout);
            }
            if (value.startStderr != -1L) {
                encoder.writeSmallLong(value.startStderr);
            }
            if (destinations != 0) {
                encoder.writeSmallLong(value.end);
            }
        }
    };
    static final long NO_OUTPUT = -1L;
    private static final OutputRanges NO_OUTPUT_RANGES = new OutputRanges(-1L, -1L, -1L);
    final long startStdout;
    final long startStderr;
    final long end;

    private static void validateRange(String name, long start, long end) {
        if (start != -1L) {
            if (start < 0L) {
                throw new IllegalStateException("Invalid " + name + " start: " + start);
            }
            if (end < start) {
                throw new IllegalStateException("Range end " + end + " is before " + name + " start " + start);
            }
        }
    }

    public static OutputRanges of(long startStdout, long startStderr, long end) {
        OutputRanges.validateRange("stdout", startStdout, end);
        OutputRanges.validateRange("stderr", startStderr, end);
        if (startStdout == -1L && startStderr == -1L) {
            if (end != -1L) {
                throw new IllegalStateException("Output range end " + end + " specified without any output range starts");
            }
            return NO_OUTPUT_RANGES;
        }
        return new OutputRanges(startStdout, startStderr, end);
    }

    private OutputRanges(long startStdout, long startStderr, long end) {
        this.startStdout = startStdout;
        this.startStderr = startStderr;
        this.end = end;
    }

    public boolean hasOutput() {
        return this.startStdout != -1L || this.startStderr != -1L;
    }
}

