/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report.generic;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.internal.tasks.testing.TestReportGenerator;
import org.gradle.api.internal.tasks.testing.junit.result.Binary2JUnitXmlReportGenerator;
import org.gradle.api.internal.tasks.testing.junit.result.JUnitXmlResultOptions;
import org.gradle.api.internal.tasks.testing.report.generic.TestTreeModelResultsProvider;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.UncheckedException;

public abstract class JunitXmlTestReportGenerator
implements TestReportGenerator {
    private final ObjectFactory objectFactory;
    private final Path reportsDirectory;
    private final JUnitXmlResultOptions xmlResultOptions;

    @Inject
    public JunitXmlTestReportGenerator(ObjectFactory objectFactory, Path reportsDirectory, JUnitXmlResultOptions xmlResultOptions) {
        this.objectFactory = objectFactory;
        this.reportsDirectory = reportsDirectory;
        this.xmlResultOptions = xmlResultOptions;
    }

    @Override
    public Path generate(List<Path> resultsDirectories) {
        try {
            Files.createDirectories(this.reportsDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        if (resultsDirectories.isEmpty()) {
            return this.reportsDirectory;
        }
        if (resultsDirectories.size() > 1) {
            throw new IllegalArgumentException("JunitXmlTestReportGenerator can only generate a report from a single results directory. Found: " + resultsDirectories);
        }
        TestTreeModelResultsProvider.useResultsFrom(resultsDirectories.get(0), resultsProvider -> ((Binary2JUnitXmlReportGenerator)this.objectFactory.newInstance(Binary2JUnitXmlReportGenerator.class, new Object[]{this.reportsDirectory.toFile(), resultsProvider, this.xmlResultOptions})).generate());
        return this.reportsDirectory;
    }
}

