/*
 * Copyright 2025 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.api.internal.tasks.testing;

import org.gradle.api.tasks.testing.SingleFileSource;
import org.jspecify.annotations.NullMarked;

import java.io.File;

@NullMarked
public final class DefaultSingleFileSource implements SingleFileSource {

    private final File file;

    public DefaultSingleFileSource(File file) {
        this.file = file;
    }

    @Override
    public File getFile() {
        return file;
    }
}
