/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.testing.AbstractTestTask;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestExecutionException;
import org.gradle.api.tasks.testing.TestFilter;
import org.gradle.execution.EntryTaskSelector;
import org.gradle.execution.TaskSelection;
import org.gradle.execution.TaskSelectionException;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.execution.plan.QueryableExecutionPlan;
import org.gradle.internal.build.event.types.BaseTestDescriptor;
import org.gradle.process.internal.DefaultJavaDebugOptions;
import org.gradle.tooling.internal.protocol.events.InternalJvmTestDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalSingleFileResourceBasedTestDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalTestDescriptor;
import org.gradle.tooling.internal.protocol.test.InternalDebugOptions;
import org.gradle.tooling.internal.protocol.test.InternalJvmTestRequest;
import org.gradle.tooling.internal.protocol.test.InternalTaskSpec;
import org.gradle.tooling.internal.protocol.test.InternalTestSpec;
import org.gradle.tooling.internal.provider.action.TestExecutionRequestAction;
import org.jspecify.annotations.NullMarked;

@NullMarked
class TestExecutionBuildConfigurationAction
implements EntryTaskSelector {
    private static final Logger LOG = Logging.getLogger(TestExecutionBuildConfigurationAction.class);
    private final TestExecutionRequestAction testExecutionRequest;

    public TestExecutionBuildConfigurationAction(TestExecutionRequestAction testExecutionRequest) {
        this.testExecutionRequest = testExecutionRequest;
    }

    public void applyTasksTo(EntryTaskSelector.Context context, ExecutionPlan plan) {
        LinkedHashSet<Task> allTasksToRun = new LinkedHashSet<Task>();
        this.collectTasksForTestDescriptors(context, allTasksToRun);
        this.collectTasksForInternalJvmTestRequest(context.getGradle(), allTasksToRun);
        this.collectTestTasks(context, allTasksToRun);
        this.configureTestTasks(allTasksToRun);
        TestExecutionBuildConfigurationAction.addEntryTasksTo(plan, allTasksToRun);
    }

    public void postProcessExecutionPlan(EntryTaskSelector.Context context, QueryableExecutionPlan plan) {
        this.configureTestTasksForTestDescriptors(context);
        this.configureTestTasksForInternalJvmTestRequest(plan);
        this.configureTestTasksInBuild(context);
    }

    private static void addEntryTasksTo(ExecutionPlan plan, Set<Task> allTasksToRun) {
        for (Task task : allTasksToRun) {
            plan.addEntryTask(task);
        }
    }

    private void configureTestTasks(Set<Task> tasks) {
        for (Task task : tasks) {
            if (!(task instanceof AbstractTestTask)) continue;
            this.configureTestTask((AbstractTestTask)task);
        }
    }

    private void configureTestTask(AbstractTestTask test) {
        test.getFilter().setFailOnNoMatchingTests(false);
        test.getOutputs().upToDateWhen(Specs.SATISFIES_NONE);
        if (test instanceof Test) {
            InternalDebugOptions debugOptions = this.testExecutionRequest.getDebugOptions();
            if (debugOptions.isDebugMode()) {
                ((Test)test).debugOptions(javaDebugOptions -> {
                    DefaultJavaDebugOptions options = (DefaultJavaDebugOptions)javaDebugOptions;
                    options.getEnabled().set((Object)true);
                    options.getPort().set((Object)debugOptions.getPort());
                    options.getServer().set((Object)false);
                    options.getSuspend().set((Object)false);
                });
            } else {
                ((Test)test).debugOptions(javaDebugOptions -> {
                    DefaultJavaDebugOptions options = (DefaultJavaDebugOptions)javaDebugOptions;
                    options.getEnabled().set((Object)false);
                });
            }
        }
    }

    private void configureTestTasksForTestDescriptors(EntryTaskSelector.Context context) {
        Map taskAndTests = this.testExecutionRequest.getTaskAndTests();
        for (Map.Entry entry : taskAndTests.entrySet()) {
            String testTaskPath = (String)entry.getKey();
            for (AbstractTestTask testTask : TestExecutionBuildConfigurationAction.queryTestTasks(context, testTaskPath)) {
                this.configureTestTask(testTask);
                for (InternalJvmTestRequest jvmTestRequest : (List)entry.getValue()) {
                    TestFilter filter = testTask.getFilter();
                    filter.includeTest(jvmTestRequest.getClassName(), jvmTestRequest.getMethodName());
                    TestExecutionBuildConfigurationAction.disableResourceBasedTests(testTask);
                }
            }
        }
        for (InternalTaskSpec taskSpec : this.testExecutionRequest.getTaskSpecs()) {
            if (!(taskSpec instanceof InternalTestSpec)) continue;
            InternalTestSpec testSpec = (InternalTestSpec)taskSpec;
            Set<AbstractTestTask> tasks = TestExecutionBuildConfigurationAction.queryTestTasks(context, taskSpec.getTaskPath());
            for (AbstractTestTask task : tasks) {
                DefaultTestFilter filter = (DefaultTestFilter)task.getFilter();
                for (String string : testSpec.getClasses()) {
                    filter.includeCommandLineTest(string, null);
                    TestExecutionBuildConfigurationAction.disableResourceBasedTests(task);
                }
                for (Map.Entry entry : testSpec.getMethods().entrySet()) {
                    String cls = (String)entry.getKey();
                    for (String method : (List)entry.getValue()) {
                        filter.includeCommandLineTest(cls, method);
                        TestExecutionBuildConfigurationAction.disableResourceBasedTests(task);
                    }
                }
                Set commandLineIncludePatterns = filter.getCommandLineIncludePatterns();
                commandLineIncludePatterns.addAll(testSpec.getPatterns());
                for (String pkg : testSpec.getPackages()) {
                    commandLineIncludePatterns.add(pkg + ".*");
                    TestExecutionBuildConfigurationAction.disableResourceBasedTests(task);
                }
            }
        }
    }

    private static void disableResourceBasedTests(AbstractTestTask testTask) {
        if (testTask instanceof Test) {
            ((Test)testTask).getTestDefinitionDirs().setFrom(new Object[0]);
        }
    }

    private void configureTestTasksForInternalJvmTestRequest(QueryableExecutionPlan plan) {
        Set internalJvmTestRequests = this.testExecutionRequest.getInternalJvmTestRequests();
        if (internalJvmTestRequests.isEmpty()) {
            return;
        }
        TestExecutionBuildConfigurationAction.forEachTaskIn(plan, task -> {
            if (task instanceof AbstractTestTask) {
                AbstractTestTask testTask = (AbstractTestTask)task;
                this.configureTestTask(testTask);
                for (InternalJvmTestRequest jvmTestRequest : internalJvmTestRequests) {
                    TestFilter filter = testTask.getFilter();
                    filter.includeTest(jvmTestRequest.getClassName(), jvmTestRequest.getMethodName());
                    TestExecutionBuildConfigurationAction.disableResourceBasedTests(testTask);
                }
            }
        });
    }

    private void configureTestTasksInBuild(EntryTaskSelector.Context context) {
        Set testDescriptors = this.testExecutionRequest.getTestExecutionDescriptors();
        TestExecutionBuildConfigurationAction.warnIfUnsupportedTestRerunningForResourceBasedTests(testDescriptors);
        for (InternalTestDescriptor descriptor : testDescriptors) {
            String testTaskPath = TestExecutionBuildConfigurationAction.taskPathOf(descriptor);
            for (AbstractTestTask testTask : TestExecutionBuildConfigurationAction.queryTestTasks(context, testTaskPath)) {
                this.configureTestTask(testTask);
                for (InternalTestDescriptor testDescriptor : testDescriptors) {
                    if (!TestExecutionBuildConfigurationAction.taskPathOf(testDescriptor).equals(testTaskPath)) continue;
                    TestExecutionBuildConfigurationAction.includeTestMatching(testDescriptor, testTask);
                }
            }
        }
    }

    private static void warnIfUnsupportedTestRerunningForResourceBasedTests(Collection<InternalTestDescriptor> testDescriptors) {
        LinkedHashSet<String> seenTasks = new LinkedHashSet<String>();
        for (InternalTestDescriptor descriptor : testDescriptors) {
            String taskPath;
            if (!(descriptor instanceof InternalSingleFileResourceBasedTestDescriptor) || seenTasks.contains(taskPath = TestExecutionBuildConfigurationAction.taskPathOf(descriptor))) continue;
            LOG.warn("Re-running resource-based tests is not supported via TestLauncher API. The '{}' task will be scheduled without further filtering.", (Object)taskPath);
            seenTasks.add(taskPath);
        }
    }

    private void collectTasksForTestDescriptors(EntryTaskSelector.Context context, Collection<Task> tasksToRun) {
        Map taskAndTests = this.testExecutionRequest.getTaskAndTests();
        for (Map.Entry entry : taskAndTests.entrySet()) {
            String testTaskPath = (String)entry.getKey();
            tasksToRun.addAll(TestExecutionBuildConfigurationAction.queryTestTasks(context, testTaskPath));
        }
        for (InternalTaskSpec taskSpec : this.testExecutionRequest.getTaskSpecs()) {
            if (taskSpec instanceof InternalTestSpec) {
                tasksToRun.addAll(TestExecutionBuildConfigurationAction.queryTestTasks(context, taskSpec.getTaskPath()));
                continue;
            }
            tasksToRun.addAll(TestExecutionBuildConfigurationAction.queryTasks(context, taskSpec.getTaskPath()));
        }
    }

    private static void includeTestMatching(InternalTestDescriptor descriptor, AbstractTestTask testTask) {
        if (descriptor instanceof InternalJvmTestDescriptor) {
            InternalJvmTestDescriptor jvmTestDescriptor = (InternalJvmTestDescriptor)descriptor;
            String className = jvmTestDescriptor.getClassName();
            String methodName = jvmTestDescriptor.getMethodName();
            if (className == null && methodName == null) {
                testTask.getFilter().includeTestsMatching("*");
            } else {
                testTask.getFilter().includeTest(className, methodName);
            }
            TestExecutionBuildConfigurationAction.disableResourceBasedTests(testTask);
        }
    }

    private void collectTestTasks(EntryTaskSelector.Context context, Collection<Task> testTasksToRun) {
        for (InternalTestDescriptor descriptor : this.testExecutionRequest.getTestExecutionDescriptors()) {
            String testTaskPath = TestExecutionBuildConfigurationAction.taskPathOf(descriptor);
            testTasksToRun.addAll(TestExecutionBuildConfigurationAction.queryTestTasks(context, testTaskPath));
        }
    }

    private static Set<Task> queryTasks(EntryTaskSelector.Context context, String testTaskPath) {
        TaskSelection taskSelection;
        try {
            taskSelection = context.getSelection(testTaskPath);
        }
        catch (TaskSelectionException e) {
            throw new TestExecutionException(String.format("Requested test task with path '%s' cannot be found.", testTaskPath));
        }
        Set tasks = taskSelection.getTasks();
        if (tasks.isEmpty()) {
            throw new TestExecutionException(String.format("Requested test task with path '%s' cannot be found.", testTaskPath));
        }
        return tasks;
    }

    private static Set<AbstractTestTask> queryTestTasks(EntryTaskSelector.Context context, String testTaskPath) {
        LinkedHashSet<AbstractTestTask> result = new LinkedHashSet<AbstractTestTask>();
        for (Task task : TestExecutionBuildConfigurationAction.queryTasks(context, testTaskPath)) {
            if (!(task instanceof AbstractTestTask)) {
                throw new TestExecutionException(String.format("Task '%s' of type '%s' not supported for executing tests via TestLauncher API.", testTaskPath, task.getClass().getName()));
            }
            result.add((AbstractTestTask)task);
        }
        return result;
    }

    private void collectTasksForInternalJvmTestRequest(GradleInternal gradle, Collection<Task> tasksToExecute) {
        Set internalJvmTestRequests = this.testExecutionRequest.getInternalJvmTestRequests();
        if (internalJvmTestRequests.isEmpty()) {
            return;
        }
        gradle.getOwner().ensureProjectsConfigured();
        for (ProjectState projectState : gradle.getOwner().getProjects().getAllProjects()) {
            projectState.ensureConfigured();
            projectState.applyToMutableState(project -> {
                TaskCollection testTasks = project.getTasks().withType(AbstractTestTask.class);
                tasksToExecute.addAll((Collection<Task>)testTasks);
            });
        }
    }

    private static void forEachTaskIn(QueryableExecutionPlan plan, Consumer<Task> taskConsumer) {
        plan.getTasks().forEach(taskConsumer);
    }

    private static String taskPathOf(InternalTestDescriptor descriptor) {
        return ((BaseTestDescriptor)descriptor).getTaskPath();
    }
}

