/*
 * Copyright 2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.tooling.events.test;

import org.gradle.api.Incubating;
import org.jspecify.annotations.NullMarked;

/**
 * A metadata information was reported by the test framework.
 * A typical source for this event is the JUnit Platform reporting ReportEntry objects.
 *
 * @since 9.4.0
 */
@Incubating
@NullMarked
public interface ReportMetadataEvent extends TestMetadataEvent {

    /**
     * The timestamp of when the metadata was recorded (and not the time the event was emitted).
     *
     * @since 9.4.0
     */
    long getMetadataTimestamp();
}
