/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report.generic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.stream.Streams;
import org.gradle.api.internal.tasks.testing.DefaultTestFileAttachmentDataEvent;
import org.gradle.api.internal.tasks.testing.DefaultTestKeyValueDataEvent;
import org.gradle.api.internal.tasks.testing.report.generic.GenericPageRenderer;
import org.gradle.api.internal.tasks.testing.report.generic.PerRootInfo;
import org.gradle.api.internal.tasks.testing.report.generic.TestTreeModel;
import org.gradle.api.internal.tasks.testing.results.serializable.OutputEntry;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableFailure;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResult;
import org.gradle.api.internal.tasks.testing.results.serializable.TestOutputReader;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.Pair;
import org.gradle.internal.html.SimpleHtmlWriter;
import org.gradle.internal.io.IoConsumer;
import org.gradle.internal.time.TimeFormatting;
import org.gradle.reporting.HtmlWriterTools;
import org.gradle.reporting.ReportRenderer;
import org.gradle.reporting.TabsRenderer;
import org.jspecify.annotations.Nullable;

public abstract class PerRootTabRenderer
extends ReportRenderer<TestTreeModel, SimpleHtmlWriter> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS z").withZone(ZoneId.systemDefault());
    protected final int rootIndex;
    private final int perRootInfoIndex;
    private @Nullable TestTreeModel currentModel;

    public PerRootTabRenderer(int rootIndex, int perRootInfoIndex) {
        this.rootIndex = rootIndex;
        this.perRootInfoIndex = perRootInfoIndex;
    }

    public void render(TestTreeModel model, SimpleHtmlWriter htmlWriter) throws IOException {
        this.currentModel = model;
        PerRootInfo info = model.getPerRootInfo().get(this.rootIndex).get(this.perRootInfoIndex);
        this.render(info, htmlWriter);
    }

    protected final TestTreeModel getCurrentModel() {
        if (this.currentModel == null) {
            throw new IllegalStateException("No model set");
        }
        return this.currentModel;
    }

    protected abstract void render(PerRootInfo var1, SimpleHtmlWriter var2) throws IOException;

    private static String formatLogTime(Instant logTime) {
        return FORMATTER.format(logTime);
    }

    public static final class ForFileAttachments
    extends PerRootTabRenderer {
        public ForFileAttachments(int rootIndex, int perRootInfoIndex) {
            super(rootIndex, perRootInfoIndex);
        }

        @Override
        protected void render(PerRootInfo info, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("div").attribute("class", "attachments");
            List<DefaultTestFileAttachmentDataEvent> keyValues = info.getMetadatas().stream().filter(DefaultTestFileAttachmentDataEvent.class::isInstance).map(DefaultTestFileAttachmentDataEvent.class::cast).collect(Collectors.toList());
            ForFileAttachments.renderFileAttachments(keyValues, htmlWriter);
            htmlWriter.endElement();
        }

        private static void renderFileAttachments(List<DefaultTestFileAttachmentDataEvent> metadatas, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("table");
            ForFileAttachments.renderFileAttachmentHeader(htmlWriter);
            ForFileAttachments.renderFileAttachmentValues(metadatas, htmlWriter);
            htmlWriter.endElement();
        }

        private static void renderFileAttachmentHeader(SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("thead").startElement("tr").startElement("th").characters((CharSequence)"Name").endElement().startElement("th").characters((CharSequence)"Content").endElement().endElement().endElement();
        }

        private static void renderFileAttachmentValues(List<DefaultTestFileAttachmentDataEvent> metadatas, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("tbody");
            for (int metadataIdx = 0; metadataIdx < metadatas.size(); ++metadataIdx) {
                DefaultTestFileAttachmentDataEvent metadata = metadatas.get(metadataIdx);
                htmlWriter.startElement("tr").attribute("class", metadataIdx % 2 == 0 ? "even" : "odd");
                htmlWriter.startElement("td").attribute("class", "key").characters((CharSequence)metadata.getPath().getFileName().toString()).endElement();
                htmlWriter.startElement("td").attribute("class", "value");
                String possibleMediaType = metadata.getMediaType();
                if (possibleMediaType == null) {
                    ForFileAttachments.renderLink(htmlWriter, metadata);
                } else {
                    MediaType mediaType = MediaType.parse((String)possibleMediaType);
                    if (mediaType.is(MediaType.ANY_IMAGE_TYPE)) {
                        ForFileAttachments.renderImage(htmlWriter, metadata);
                    } else if (mediaType.is(MediaType.ANY_VIDEO_TYPE)) {
                        ForFileAttachments.renderVideo(htmlWriter, metadata);
                    } else {
                        ForFileAttachments.renderLink(htmlWriter, metadata);
                    }
                }
                htmlWriter.endElement();
                htmlWriter.endElement();
            }
            htmlWriter.endElement();
        }

        private static void renderLink(SimpleHtmlWriter htmlWriter, DefaultTestFileAttachmentDataEvent metadata) throws IOException {
            htmlWriter.startElement("a").attribute("href", htmlWriter.relativeLink(metadata.getPath())).characters((CharSequence)htmlWriter.relativeLink(metadata.getPath())).endElement();
        }

        private static void renderImage(SimpleHtmlWriter htmlWriter, DefaultTestFileAttachmentDataEvent metadata) throws IOException {
            htmlWriter.startElement("img").attribute("src", htmlWriter.relativeLink(metadata.getPath())).attribute("alt", metadata.getPath().getFileName().toString()).endElement();
        }

        private static void renderVideo(SimpleHtmlWriter htmlWriter, DefaultTestFileAttachmentDataEvent metadata) throws IOException {
            htmlWriter.startElement("video").attribute("src", htmlWriter.relativeLink(metadata.getPath())).attribute("controls", "").startElement("a").attribute("href", htmlWriter.relativeLink(metadata.getPath())).characters((CharSequence)"Download video").endElement().endElement();
        }
    }

    public static final class ForKeyValues
    extends PerRootTabRenderer {
        public ForKeyValues(int rootIndex, int perRootInfoIndex) {
            super(rootIndex, perRootInfoIndex);
        }

        @Override
        protected void render(PerRootInfo info, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("div").attribute("class", "metadata");
            List<DefaultTestKeyValueDataEvent> keyValues = info.getMetadatas().stream().filter(DefaultTestKeyValueDataEvent.class::isInstance).map(DefaultTestKeyValueDataEvent.class::cast).collect(Collectors.toList());
            ForKeyValues.renderKeyValueTable(keyValues, htmlWriter);
            htmlWriter.endElement();
        }

        private static void renderKeyValueTable(List<DefaultTestKeyValueDataEvent> metadatas, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("table");
            ForKeyValues.renderKeyValueHeader(htmlWriter);
            ForKeyValues.renderKeyValueValues(metadatas, htmlWriter);
            htmlWriter.endElement();
        }

        private static void renderKeyValueHeader(SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("thead").startElement("tr").startElement("th").characters((CharSequence)"Time").endElement().startElement("th").characters((CharSequence)"Key").endElement().startElement("th").characters((CharSequence)"Value").endElement().endElement().endElement();
        }

        private static void renderKeyValueValues(List<DefaultTestKeyValueDataEvent> metadatas, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("tbody");
            for (int metadataIdx = 0; metadataIdx < metadatas.size(); ++metadataIdx) {
                DefaultTestKeyValueDataEvent metadata = metadatas.get(metadataIdx);
                Map elements = metadata.getValues();
                htmlWriter.startElement("tr").attribute("class", metadataIdx % 2 == 0 ? "even" : "odd");
                htmlWriter.startElement("td").attribute("rowspan", Integer.toString(metadata.getValues().size() + 1)).startElement("span").attribute("class", "time").characters((CharSequence)PerRootTabRenderer.formatLogTime(metadata.getLogTime())).endElement().endElement();
                htmlWriter.endElement();
                for (Map.Entry element : elements.entrySet()) {
                    htmlWriter.startElement("tr").attribute("class", metadataIdx % 2 == 0 ? "even" : "odd");
                    htmlWriter.startElement("td").attribute("class", "key").characters((CharSequence)element.getKey()).endElement().startElement("td").attribute("class", "value").characters((CharSequence)element.getValue()).endElement();
                    htmlWriter.endElement();
                }
            }
            htmlWriter.endElement();
        }
    }

    public static final class ForOutput
    extends PerRootTabRenderer {
        private final TestOutputReader outputReader;
        private final TestOutputEvent.Destination destination;

        public ForOutput(int rootIndex, int perRootInfoIndex, TestOutputReader outputReader, TestOutputEvent.Destination destination) {
            super(rootIndex, perRootInfoIndex);
            this.outputReader = outputReader;
            this.destination = destination;
        }

        @Override
        protected void render(PerRootInfo info, SimpleHtmlWriter htmlWriter) throws IOException {
            String outputId = "root-" + this.rootIndex + "-test-" + this.destination.name().toLowerCase(Locale.ROOT) + "-" + info.getResult().getName();
            htmlWriter.startElement("span").attribute("class", "code").startElement("pre").attribute("id", outputId);
            OutputEntry outputEntry = info.getOutputEntry();
            if (outputEntry != null) {
                this.outputReader.useTestOutputEvents(outputEntry, this.destination, (IoConsumer<TestOutputEvent>)((IoConsumer)event -> htmlWriter.characters((CharSequence)event.getMessage())));
            }
            htmlWriter.endElement();
            HtmlWriterTools.addClipboardCopyButton((SimpleHtmlWriter)htmlWriter, (String)outputId);
            htmlWriter.endElement();
        }
    }

    public static final class ForSummary
    extends PerRootTabRenderer {
        public ForSummary(int rootIndex, int perRootInfoIndex) {
            super(rootIndex, perRootInfoIndex);
        }

        @Override
        protected void render(PerRootInfo info, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("div");
            ForSummary.renderSummary(info, htmlWriter, info.getResult());
            if (info.getChildren().isEmpty()) {
                this.renderLeafDetails(info, htmlWriter);
            } else {
                this.renderContainerDetails(htmlWriter);
            }
            htmlWriter.endElement();
        }

        private void renderContainerDetails(SimpleHtmlWriter htmlWriter) throws IOException {
            ReportRenderer renderer;
            List<Pair<String, ChildTableRenderer>> childTableRenderers = this.getChildTableRenderers();
            if (childTableRenderers.size() == 1) {
                renderer = Objects.requireNonNull((ChildTableRenderer)((Object)childTableRenderers.get((int)0).right));
            } else {
                TabsRenderer tabsRenderer = new TabsRenderer();
                childTableRenderers.forEach(p -> tabsRenderer.add((String)p.left, (ReportRenderer)p.right));
                renderer = tabsRenderer;
            }
            renderer.render((Object)this.getCurrentModel(), (Object)htmlWriter);
        }

        private List<Pair<String, ChildTableRenderer>> getChildTableRenderers() {
            List<ChildEntry> children = Streams.of(this.getCurrentModel().getChildrenOf(this.rootIndex)).flatMap(t -> t.getPerRootInfo().get(this.rootIndex).stream().map(p -> new ChildEntry((TestTreeModel)t, (PerRootInfo)p))).collect(Collectors.toList());
            ImmutableList.Builder childTableRenderers = ImmutableList.builder();
            ForSummary.addResultTabIfNeeded("Failed", TestResult.ResultType.FAILURE, children, (ImmutableList.Builder<Pair<String, ChildTableRenderer>>)childTableRenderers);
            ForSummary.addResultTabIfNeeded("Skipped", TestResult.ResultType.SKIPPED, children, (ImmutableList.Builder<Pair<String, ChildTableRenderer>>)childTableRenderers);
            childTableRenderers.add((Object)Pair.of((Object)"All", (Object)((Object)new ChildTableRenderer(children))));
            return childTableRenderers.build();
        }

        private static void addResultTabIfNeeded(String name, TestResult.ResultType resultType, List<ChildEntry> children, ImmutableList.Builder<Pair<String, ChildTableRenderer>> childListRenderers) {
            List<ChildEntry> matchedChildren = children.stream().filter(e -> ((ChildEntry)e).perRootInfo.getResult().getResultType() == resultType).collect(Collectors.toList());
            if (!matchedChildren.isEmpty()) {
                childListRenderers.add((Object)Pair.of((Object)name, (Object)((Object)new ChildTableRenderer(matchedChildren))));
            }
        }

        private static void renderSummary(PerRootInfo info, SimpleHtmlWriter htmlWriter, SerializableTestResult testResult) throws IOException {
            htmlWriter.startElement("div").attribute("class", "summary");
            htmlWriter.startElement("table");
            htmlWriter.startElement("tr");
            htmlWriter.startElement("td");
            ForSummary.renderSummaryGroup(info, htmlWriter, testResult);
            htmlWriter.endElement();
            htmlWriter.startElement("td");
            htmlWriter.startElement("div").attribute("class", "infoBox " + ForSummary.getStatusClass(testResult.getResultType()) + " successRate");
            htmlWriter.startElement("div").attribute("class", "percent").characters((CharSequence)ForSummary.getFormattedSuccessRate(info)).endElement();
            htmlWriter.startElement("p").characters((CharSequence)"successful").endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
        }

        private static void renderSummaryGroup(PerRootInfo info, SimpleHtmlWriter htmlWriter, SerializableTestResult testResult) throws IOException {
            htmlWriter.startElement("div").attribute("class", "summaryGroup");
            htmlWriter.startElement("table");
            htmlWriter.startElement("tr");
            htmlWriter.startElement("td");
            htmlWriter.startElement("div").attribute("class", "infoBox");
            htmlWriter.startElement("div").attribute("class", "counter").characters((CharSequence)Integer.toString(info.getTotalLeafCount())).endElement();
            htmlWriter.startElement("p").characters((CharSequence)"tests").endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.startElement("td");
            htmlWriter.startElement("div").attribute("class", "infoBox");
            htmlWriter.startElement("div").attribute("class", "counter").characters((CharSequence)Integer.toString(info.getFailedLeafCount())).endElement();
            htmlWriter.startElement("p").characters((CharSequence)"failures").endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.startElement("td");
            htmlWriter.startElement("div").attribute("class", "infoBox");
            htmlWriter.startElement("div").attribute("class", "counter").characters((CharSequence)Integer.toString(info.getSkippedLeafCount())).endElement();
            htmlWriter.startElement("p").characters((CharSequence)"skipped").endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.startElement("td");
            htmlWriter.startElement("div").attribute("class", "infoBox duration");
            htmlWriter.startElement("div").attribute("class", "counter").characters((CharSequence)ForSummary.getFormattedDuration(testResult)).endElement();
            htmlWriter.startElement("p").characters((CharSequence)"duration").endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
        }

        private static String getFormattedDuration(SerializableTestResult testResult) {
            return TimeFormatting.formatDurationVeryTerse((long)testResult.getDuration());
        }

        private void renderLeafDetails(PerRootInfo info, SimpleHtmlWriter htmlWriter) throws IOException {
            boolean hasAssumptionFailure;
            boolean isSuccess = info.getResult().getResultType() == TestResult.ResultType.SUCCESS;
            boolean hasFailures = !info.getResult().getFailures().isEmpty();
            boolean bl = hasAssumptionFailure = info.getResult().getAssumptionFailure() != null;
            if (!isSuccess && (hasFailures || hasAssumptionFailure)) {
                htmlWriter.startElement("div").attribute("class", "result-details");
                htmlWriter.startElement("h3").characters((CharSequence)(info.getResult().getResultType() == TestResult.ResultType.FAILURE ? "Failure details" : "Skip details")).endElement();
                String failureOutputId = "root-" + this.rootIndex + "-test-failure-" + info.getResult().getName();
                htmlWriter.startElement("span").attribute("class", "code");
                htmlWriter.startElement("pre").attribute("id", failureOutputId);
                if (hasFailures) {
                    for (SerializableFailure failure : info.getResult().getFailures()) {
                        this.renderFailure(failure, htmlWriter);
                    }
                }
                if (hasAssumptionFailure) {
                    this.renderFailure(info.getResult().getAssumptionFailure(), htmlWriter);
                }
                htmlWriter.endElement();
                HtmlWriterTools.addClipboardCopyButton((SimpleHtmlWriter)htmlWriter, (String)failureOutputId);
                htmlWriter.endElement();
                htmlWriter.endElement();
            }
        }

        private void renderFailure(SerializableFailure failure, SimpleHtmlWriter htmlWriter) throws IOException {
            if (failure.getStackTrace().isEmpty()) {
                htmlWriter.characters((CharSequence)(failure.getMessage() + "\n"));
            } else {
                htmlWriter.characters((CharSequence)failure.getStackTrace());
            }
            for (int i = 0; i < failure.getCauses().size(); ++i) {
                htmlWriter.characters((CharSequence)("Cause " + (i + 1) + ": " + failure.getCauses().get(i) + "\n"));
            }
        }

        private static String getStatusClass(TestResult.ResultType resultType) {
            switch (resultType) {
                case SUCCESS: {
                    return "success";
                }
                case FAILURE: {
                    return "failures";
                }
                case SKIPPED: {
                    return "skipped";
                }
            }
            throw new IllegalStateException();
        }

        private static String getFormattedSuccessRate(PerRootInfo info) {
            if (info.getTotalLeafCount() == 0) {
                return "-";
            }
            BigDecimal runTests = BigDecimal.valueOf(info.getTotalLeafCount());
            BigDecimal successful = BigDecimal.valueOf(info.getTotalLeafCount() - info.getFailedLeafCount());
            return successful.divide(runTests, 2, RoundingMode.DOWN).multiply(BigDecimal.valueOf(100L)).intValue() + "%";
        }

        private static final class ChildTableRenderer
        extends ReportRenderer<TestTreeModel, SimpleHtmlWriter> {
            private static final Comparator<ChildEntry> CHILD_PATH_COMPARATOR = Comparator.comparing(e -> ((ChildEntry)e).model.getPath());
            private final List<ChildEntry> children;

            public ChildTableRenderer(List<ChildEntry> children) {
                this.children = children;
            }

            public void render(TestTreeModel model, SimpleHtmlWriter htmlWriter) throws IOException {
                htmlWriter.startElement("table").attribute("class", "test-results");
                htmlWriter.startElement("thead");
                htmlWriter.startElement("tr");
                boolean anyNameAndDisplayNameDiffer = Iterables.any(this.children, child -> {
                    SerializableTestResult childResult = ((ChildEntry)child).perRootInfo.getResult();
                    return !childResult.getName().equals(childResult.getDisplayName());
                });
                htmlWriter.startElement("th").characters((CharSequence)"Child").endElement();
                if (anyNameAndDisplayNameDiffer) {
                    htmlWriter.startElement("th").characters((CharSequence)"Name").endElement();
                }
                htmlWriter.startElement("th").characters((CharSequence)"Tests").endElement();
                htmlWriter.startElement("th").characters((CharSequence)"Failures").endElement();
                htmlWriter.startElement("th").characters((CharSequence)"Skipped").endElement();
                htmlWriter.startElement("th").characters((CharSequence)"Duration").endElement();
                htmlWriter.startElement("th").characters((CharSequence)"Success rate").endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                ArrayList<ChildEntry> sortedByName = new ArrayList<ChildEntry>(this.children);
                sortedByName.sort(CHILD_PATH_COMPARATOR);
                for (ChildEntry pair : sortedByName) {
                    PerRootInfo perRootInfo = pair.perRootInfo;
                    SerializableTestResult result = perRootInfo.getResult();
                    String statusClass = ForSummary.getStatusClass(result.getResultType());
                    htmlWriter.startElement("tr");
                    htmlWriter.startElement("td").attribute("class", statusClass);
                    htmlWriter.startElement("a").attribute("href", GenericPageRenderer.getUrlTo(model.getPath(), false, pair.model.getPath(), pair.model.getChildren().isEmpty())).characters((CharSequence)result.getDisplayName()).endElement();
                    htmlWriter.endElement();
                    if (anyNameAndDisplayNameDiffer) {
                        htmlWriter.startElement("td").characters((CharSequence)result.getName()).endElement();
                    }
                    htmlWriter.startElement("td").characters((CharSequence)Integer.toString(perRootInfo.getTotalLeafCount())).endElement();
                    htmlWriter.startElement("td").characters((CharSequence)Integer.toString(perRootInfo.getFailedLeafCount())).endElement();
                    htmlWriter.startElement("td").characters((CharSequence)Integer.toString(perRootInfo.getSkippedLeafCount())).endElement();
                    htmlWriter.startElement("td").characters((CharSequence)ForSummary.getFormattedDuration(result)).endElement();
                    htmlWriter.startElement("td").attribute("class", statusClass).characters((CharSequence)ForSummary.getFormattedSuccessRate(perRootInfo)).endElement();
                    htmlWriter.endElement();
                }
                htmlWriter.endElement();
            }
        }

        private static final class ChildEntry {
            private final TestTreeModel model;
            private final PerRootInfo perRootInfo;

            private ChildEntry(TestTreeModel model, PerRootInfo perRootInfo) {
                this.model = model;
                this.perRootInfo = perRootInfo;
            }
        }
    }
}

