/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.composite.BuildIncludeListener;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.gradle.internal.problems.failure.Failure;
import org.gradle.internal.problems.failure.FailureFactory;
import org.gradle.plugins.ide.internal.tooling.GradleBuildBuilder;
import org.gradle.plugins.ide.internal.tooling.model.BasicGradleProject;
import org.gradle.plugins.ide.internal.tooling.model.DefaultGradleBuild;
import org.gradle.tooling.internal.gradle.DefaultBuildIdentifier;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.provider.model.internal.BuildScopeModelBuilder;
import org.gradle.tooling.provider.model.internal.ToolingModelBuilderResultInternal;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ResilientGradleBuildBuilder
implements BuildScopeModelBuilder {
    private final BuildStateRegistry buildStateRegistry;
    private final BuildIncludeListener failedIncludedBuildsRegistry;
    private final FailureFactory failureFactory;

    public ResilientGradleBuildBuilder(BuildStateRegistry buildStateRegistry, BuildIncludeListener failedIncludedBuildsRegistry, FailureFactory failureFactory) {
        this.buildStateRegistry = buildStateRegistry;
        this.failedIncludedBuildsRegistry = failedIncludedBuildsRegistry;
        this.failureFactory = failureFactory;
    }

    public boolean canBuild(String modelName) {
        return "org.gradle.tooling.model.gradle.GradleBuild".equals(modelName);
    }

    public ToolingModelBuilderResultInternal create(BuildState target) {
        return new ResilientGradleBuildCreator(target).create();
    }

    @NullMarked
    private class ResilientGradleBuildCreator {
        private final BuildState target;
        private final Map<BuildState, DefaultGradleBuild> all = new LinkedHashMap<BuildState, DefaultGradleBuild>();
        private final Collection<Failure> failures = new LinkedHashSet<Failure>();

        ResilientGradleBuildCreator(BuildState target) {
            this.target = target;
        }

        ToolingModelBuilderResultInternal create() {
            this.ensureProjectsLoaded(this.target);
            DefaultGradleBuild gradleBuild = this.convert(this.target);
            List allFailures = (List)this.failures.stream().distinct().collect(ImmutableList.toImmutableList());
            return ToolingModelBuilderResultInternal.of((Object)gradleBuild, (List)allFailures);
        }

        protected void addIncludedBuilds(GradleInternal gradle, DefaultGradleBuild model) {
            for (IncludedBuildInternal reference : gradle.includedBuilds()) {
                BuildState target = reference.getTarget();
                if (target instanceof IncludedBuildState || target instanceof RootBuildState) {
                    model.addIncludedBuild(this.convert(target));
                    continue;
                }
                throw new IllegalStateException("Unknown build type: " + reference.getClass().getName());
            }
        }

        protected void addAllImportableBuilds(BuildState targetBuild, GradleInternal gradle, DefaultGradleBuild model) {
            if (gradle.getParent() == null) {
                ArrayList<DefaultGradleBuild> allBuilds = new ArrayList<DefaultGradleBuild>();
                ResilientGradleBuildBuilder.this.buildStateRegistry.visitBuilds(buildState -> {
                    if (buildState != targetBuild && buildState.isImportableBuild()) {
                        allBuilds.add(this.convert((BuildState)buildState));
                    }
                });
                model.addBuilds(allBuilds);
            }
        }

        protected void ensureProjectsLoaded(BuildState target) {
            try {
                target.ensureProjectsLoaded();
            }
            catch (GradleException e) {
                this.failures.add(ResilientGradleBuildBuilder.this.failureFactory.create((Throwable)e));
            }
        }

        protected DefaultGradleBuild convert(BuildState targetBuild) {
            DefaultGradleBuild model = this.all.get(targetBuild);
            if (model != null) {
                return model;
            }
            model = new DefaultGradleBuild();
            this.all.put(targetBuild, model);
            this.ensureProjectsLoaded(targetBuild);
            Set brokenSettings = ResilientGradleBuildBuilder.this.failedIncludedBuildsRegistry.getBrokenSettings();
            if (!brokenSettings.contains(targetBuild) && !brokenSettings.isEmpty()) {
                SettingsInternal settingsEntry = (SettingsInternal)brokenSettings.iterator().next();
                ProjectDescriptor rootProject = settingsEntry.getRootProject();
                BasicGradleProject root = this.convertRoot(targetBuild, rootProject);
                model.setRootProject(root);
                model.addProject(root);
            }
            if (targetBuild instanceof IncludedBuildState) {
                model.setBuildIdentifier((BuildIdentifier)new DefaultBuildIdentifier(((IncludedBuildState)targetBuild).getBuildDefinition().getBuildRootDir()));
            }
            GradleInternal gradle = targetBuild.getMutableModel();
            if (targetBuild.isProjectsLoaded()) {
                GradleBuildBuilder.addProjects(targetBuild, model);
            }
            try {
                this.addFailedBuilds(targetBuild, model);
                this.addIncludedBuilds(gradle, model);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.addAllImportableBuilds(targetBuild, gradle, model);
            return model;
        }

        protected BasicGradleProject convertRoot(BuildState owner, ProjectDescriptor project) {
            DefaultProjectIdentifier id = new DefaultProjectIdentifier(owner.getBuildRootDir(), project.getPath());
            return new BasicGradleProject().setName(project.getName()).setProjectIdentifier(id).setBuildTreePath(project.getPath()).setProjectDirectory(project.getProjectDir());
        }

        private void addFailedBuilds(BuildState targetBuild, DefaultGradleBuild model) {
            for (BuildState entry : ResilientGradleBuildBuilder.this.failedIncludedBuildsRegistry.getBrokenBuilds()) {
                BuildState parent = entry.getParent();
                if (parent == null || !parent.equals(targetBuild)) continue;
                model.addIncludedBuild(this.convert(entry));
            }
        }
    }
}

