/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import com.google.common.base.Objects;
import java.io.Serializable;
import org.gradle.api.Incubating;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.util.internal.TextUtil;
import org.jspecify.annotations.Nullable;

@Incubating
public class DefaultProblemGroup
extends ProblemGroup
implements Serializable {
    private final String name;
    private final String displayName;
    private final ProblemGroup parent;

    public DefaultProblemGroup(String groupId, String displayName) {
        this(groupId, displayName, null);
    }

    public DefaultProblemGroup(String name, String displayName, @Nullable ProblemGroup parent) {
        DefaultProblemGroup.validateFields(name, displayName);
        this.name = TextUtil.replaceLineSeparatorsOf((String)name, (String)"");
        this.displayName = TextUtil.replaceLineSeparatorsOf((String)displayName, (String)"");
        this.parent = parent;
    }

    private static void validateFields(String name, String displayName) {
        if (TextUtil.isBlank((String)name)) {
            throw new IllegalArgumentException("Problem group name must not be blank");
        }
        if (TextUtil.isBlank((String)displayName)) {
            throw new IllegalArgumentException("Problem group displayName must not be blank");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public @Nullable ProblemGroup getParent() {
        return this.parent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass().isAssignableFrom(ProblemGroup.class)) {
            return false;
        }
        ProblemGroup that = (ProblemGroup)o;
        return Objects.equal((Object)this.parent, (Object)that.getParent()) && Objects.equal((Object)this.name, (Object)that.getName());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.parent});
    }
}

