/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.internal.Try;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.DefaultBuildToolingModelController;
import org.gradle.internal.buildtree.ToolingModelRequestContext;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.problems.failure.Failure;
import org.gradle.internal.problems.failure.FailureFactory;
import org.gradle.tooling.provider.model.UnknownModelException;
import org.gradle.tooling.provider.model.internal.ToolingModelBuilderLookup;
import org.gradle.tooling.provider.model.internal.ToolingModelBuilderResultInternal;
import org.gradle.tooling.provider.model.internal.ToolingModelParameterCarrier;
import org.gradle.tooling.provider.model.internal.ToolingModelScope;
import org.jspecify.annotations.Nullable;

public class ResilientBuildToolingModelController
extends DefaultBuildToolingModelController {
    private static final Set<String> RESILIENT_MODELS = ImmutableSet.of((Object)"org.gradle.tooling.model.kotlin.dsl.KotlinDslScriptsModel");
    private final FailureFactory failureFactory;

    public ResilientBuildToolingModelController(BuildState buildState, BuildLifecycleController buildController, ToolingModelBuilderLookup buildScopeLookup, FailureFactory failureFactory) {
        super(buildState, buildController, buildScopeLookup);
        this.failureFactory = failureFactory;
    }

    @Override
    protected Try<Void> configureBuild() {
        return ResilientBuildToolingModelController.tryRunConfiguration(this.buildController::configureProjectsIgnoringLaterFailures);
    }

    @Override
    protected Try<ToolingModelScope> doLocate(ProjectState targetProject, ToolingModelRequestContext toolingModelContext, Try<Void> buildConfiguration) {
        return Try.successful((Object)new ResilientProjectToolingScope(targetProject, toolingModelContext, buildConfiguration, this.failureFactory));
    }

    private static boolean canRunEvenIfProjectNotFullyConfigured(String modelName) {
        return RESILIENT_MODELS.contains(modelName);
    }

    private static List<Failure> getConfigurationFailure(FailureFactory failureFactory, Try<Void> configuration) {
        Optional failure = configuration.getFailure();
        return (List)failure.map(e -> ImmutableList.of((Object)failureFactory.create(e))).orElseGet(ImmutableList::of);
    }

    private static class ResilientProjectToolingScope
    extends DefaultBuildToolingModelController.ProjectToolingScope {
        private final FailureFactory failureFactory;
        private final Try<Void> ownerBuildConfiguration;

        public ResilientProjectToolingScope(ProjectState targetProject, ToolingModelRequestContext toolingModelRequestContext, Try<Void> ownerBuildConfiguration, FailureFactory failureFactory) {
            super(targetProject, toolingModelRequestContext);
            this.ownerBuildConfiguration = ownerBuildConfiguration;
            this.failureFactory = failureFactory;
        }

        @Override
        public ToolingModelBuilderResultInternal getModel(ToolingModelRequestContext modelName, @Nullable ToolingModelParameterCarrier parameter) {
            if (!this.targetProject.isCreated()) {
                Preconditions.checkArgument((!this.ownerBuildConfiguration.isSuccessful() ? 1 : 0) != 0, (Object)"Project has not been created, but build configuration has succeeded, this is a bug, please report.");
                return ToolingModelBuilderResultInternal.of(ResilientBuildToolingModelController.getConfigurationFailure(this.failureFactory, (Try<Void>)this.ownerBuildConfiguration));
            }
            return super.getModel(modelName, parameter);
        }

        @Override
        ToolingModelBuilderLookup.Builder locateBuilder() throws UnknownModelException {
            Try<Void> projectConfiguration = this.ownerBuildConfiguration.isSuccessful() ? DefaultBuildToolingModelController.tryRunConfiguration(this.targetProject::ensureConfigured) : this.ownerBuildConfiguration;
            ProjectInternal project = this.targetProject.getMutableModelEvenAfterFailure();
            ToolingModelBuilderLookup lookup = (ToolingModelBuilderLookup)project.getServices().get(ToolingModelBuilderLookup.class);
            Supplier<ToolingModelBuilderLookup.Builder> builder = () -> lookup.locateForClientOperation(this.modelName, this.parameter, this.targetProject, project);
            boolean canRunEvenIfProjectNotFullyConfigured = ResilientBuildToolingModelController.canRunEvenIfProjectNotFullyConfigured(this.modelName);
            return new ResilientToolingModelBuilder(builder, projectConfiguration, this.failureFactory, canRunEvenIfProjectNotFullyConfigured);
        }
    }

    private static class ResilientToolingModelBuilder
    implements ToolingModelBuilderLookup.Builder {
        private final Lazy<ToolingModelBuilderLookup.Builder> delegate;
        private final Try<Void> projectConfiguration;
        private final FailureFactory failureFactory;
        private final boolean canRunEvenIfProjectNotFullyConfigured;

        public ResilientToolingModelBuilder(Supplier<ToolingModelBuilderLookup.Builder> delegate, Try<Void> projectConfiguration, FailureFactory failureFactory, boolean canRunEvenIfProjectNotFullyConfigured) {
            this.delegate = Lazy.unsafe().of(delegate);
            this.projectConfiguration = projectConfiguration;
            this.failureFactory = failureFactory;
            this.canRunEvenIfProjectNotFullyConfigured = canRunEvenIfProjectNotFullyConfigured;
        }

        @Override
        public @Nullable Class<?> getParameterType() {
            return ((ToolingModelBuilderLookup.Builder)this.delegate.get()).getParameterType();
        }

        @Override
        public Object build(@Nullable Object parameter) {
            if (this.projectConfiguration.isSuccessful()) {
                return ((ToolingModelBuilderLookup.Builder)this.delegate.get()).build(parameter);
            }
            Object model = this.canRunEvenIfProjectNotFullyConfigured ? ((ToolingModelBuilderLookup.Builder)this.delegate.get()).build(parameter) : null;
            List failures = ResilientBuildToolingModelController.getConfigurationFailure(this.failureFactory, (Try<Void>)this.projectConfiguration);
            return ToolingModelBuilderResultInternal.attachFailures(model, failures);
        }
    }
}

