/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.internal.Try;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildToolingModelController;
import org.gradle.internal.buildtree.ToolingModelRequestContext;
import org.gradle.tooling.provider.model.UnknownModelException;
import org.gradle.tooling.provider.model.internal.ToolingModelBuilderLookup;
import org.gradle.tooling.provider.model.internal.ToolingModelBuilderResultInternal;
import org.gradle.tooling.provider.model.internal.ToolingModelParameterCarrier;
import org.gradle.tooling.provider.model.internal.ToolingModelScope;
import org.jspecify.annotations.Nullable;

public class DefaultBuildToolingModelController
implements BuildToolingModelController {
    protected final BuildLifecycleController buildController;
    private final BuildState buildState;
    private final ToolingModelBuilderLookup buildScopeLookup;

    public DefaultBuildToolingModelController(BuildState buildState, BuildLifecycleController buildController, ToolingModelBuilderLookup buildScopeLookup) {
        this.buildState = buildState;
        this.buildController = buildController;
        this.buildScopeLookup = buildScopeLookup;
    }

    @Override
    public GradleInternal getConfiguredModel() {
        return this.buildController.getConfiguredBuild();
    }

    @Override
    public ToolingModelScope locateBuilderForTarget(ToolingModelRequestContext toolingModelContext) {
        ToolingModelBuilderLookup.Builder builder = this.buildScopeLookup.maybeLocateForBuildScope(toolingModelContext.getModelName(), toolingModelContext.getParameter().isPresent(), this.buildState);
        if (builder != null) {
            return new BuildToolingScope(builder);
        }
        ProjectState defaultProject = this.buildController.withProjectsConfigured(gradle -> gradle.getDefaultProject().getOwner());
        Try<ToolingModelScope> toolingModelScope = this.doLocate(defaultProject, toolingModelContext, (Try<Void>)Try.successful(null));
        return (ToolingModelScope)Preconditions.checkNotNull((Object)((ToolingModelScope)toolingModelScope.get()));
    }

    @Override
    public ToolingModelScope locateBuilderForTarget(ProjectState target, ToolingModelRequestContext toolingModelContext) {
        if (target.getOwner() != this.buildState) {
            throw new IllegalArgumentException("Project has unexpected owner.");
        }
        Try<Void> buildConfiguration = this.configureBuild();
        Try<ToolingModelScope> toolingModelScope = this.doLocate(target, toolingModelContext, buildConfiguration);
        return (ToolingModelScope)Preconditions.checkNotNull((Object)((ToolingModelScope)toolingModelScope.get()));
    }

    protected Try<Void> configureBuild() {
        return DefaultBuildToolingModelController.tryRunConfiguration(this.buildController::configureProjects);
    }

    protected Try<ToolingModelScope> doLocate(ProjectState targetProject, ToolingModelRequestContext toolingModelContext, Try<Void> buildConfiguration) {
        return buildConfiguration.map(__ -> new ProjectToolingScope(targetProject, toolingModelContext));
    }

    protected static Try<Void> tryRunConfiguration(Runnable configuration) {
        return Try.ofFailable(() -> {
            configuration.run();
            return null;
        });
    }

    private static class BuildToolingScope
    extends AbstractToolingScope {
        private final ToolingModelBuilderLookup.Builder builder;

        public BuildToolingScope(ToolingModelBuilderLookup.Builder builder) {
            this.builder = builder;
        }

        @Override
        public @Nullable ProjectState getTarget() {
            return null;
        }

        @Override
        ToolingModelBuilderLookup.Builder locateBuilder() throws UnknownModelException {
            return this.builder;
        }
    }

    protected static class ProjectToolingScope
    extends AbstractToolingScope {
        protected final ProjectState targetProject;
        protected final String modelName;
        protected final boolean parameter;

        public ProjectToolingScope(ProjectState targetProject, ToolingModelRequestContext toolingModelRequestContext) {
            this.targetProject = targetProject;
            this.modelName = toolingModelRequestContext.getModelName();
            this.parameter = toolingModelRequestContext.getParameter().isPresent();
        }

        @Override
        public @Nullable ProjectState getTarget() {
            return this.targetProject;
        }

        @Override
        ToolingModelBuilderLookup.Builder locateBuilder() throws UnknownModelException {
            this.targetProject.ensureConfigured();
            ToolingModelBuilderLookup lookup = (ToolingModelBuilderLookup)this.targetProject.getMutableModel().getServices().get(ToolingModelBuilderLookup.class);
            return lookup.locateForClientOperation(this.modelName, this.parameter, this.targetProject, this.targetProject.getMutableModel());
        }
    }

    private static abstract class AbstractToolingScope
    implements ToolingModelScope {
        private AbstractToolingScope() {
        }

        abstract ToolingModelBuilderLookup.Builder locateBuilder() throws UnknownModelException;

        @Override
        public ToolingModelBuilderResultInternal getModel(ToolingModelRequestContext modelRequestContext, @Nullable ToolingModelParameterCarrier parameter) {
            Object model = this.buildModelWithParameter(parameter);
            if (!(model instanceof ToolingModelBuilderResultInternal)) {
                return ToolingModelBuilderResultInternal.of(model);
            }
            ToolingModelBuilderResultInternal resultInternal = (ToolingModelBuilderResultInternal)model;
            if (!modelRequestContext.inResilientContext()) {
                resultInternal.throwFailureIfPresent();
            }
            return resultInternal;
        }

        private Object buildModelWithParameter(@Nullable ToolingModelParameterCarrier parameter) {
            ToolingModelBuilderLookup.Builder builder = this.locateBuilder();
            if (parameter == null) {
                return builder.build(null);
            }
            Class<?> expectedParameterType = Objects.requireNonNull(builder.getParameterType(), "Expected builder with parameter support");
            Object parameterValue = parameter.getView(expectedParameterType);
            return builder.build(parameterValue);
        }
    }
}

