/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.launcher.cli.WelcomeMessageConfiguration;
import org.gradle.api.launcher.cli.WelcomeMessageDisplayMode;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.configuration.DefaultBuildClientMetaData;
import org.gradle.configuration.GradleLauncherMetaData;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.internal.Actions;
import org.gradle.internal.buildevents.BuildExceptionReporter;
import org.gradle.internal.buildoption.BuildOptionSet;
import org.gradle.internal.logging.DefaultLoggingConfiguration;
import org.gradle.internal.logging.LoggingConfigurationBuildOptions;
import org.gradle.internal.logging.LoggingManagerFactory;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.LoggingOutputInternal;
import org.gradle.internal.logging.services.LoggingServiceRegistry;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.problems.failure.DefaultFailureFactory;
import org.gradle.internal.problems.failure.FailureFactory;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.BasicGlobalScopeServices;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.launcher.bootstrap.CommandLineActionFactory;
import org.gradle.launcher.bootstrap.ExecutionListener;
import org.gradle.launcher.cli.BuildActionsFactory;
import org.gradle.launcher.cli.BuildEnvironmentConfigurationConverter;
import org.gradle.launcher.cli.CommandLineActionCreator;
import org.gradle.launcher.cli.ContinuingAction;
import org.gradle.launcher.cli.DebugLoggerWarningAction;
import org.gradle.launcher.cli.ExceptionReportingAction;
import org.gradle.launcher.cli.NativeServicesInitializingAction;
import org.gradle.launcher.cli.Parameters;
import org.gradle.launcher.cli.WelcomeMessageAction;
import org.gradle.launcher.cli.converter.BuildLayoutConverter;
import org.gradle.launcher.cli.converter.BuildOptionBackedConverter;
import org.gradle.launcher.cli.converter.InitialPropertiesConverter;
import org.gradle.launcher.cli.converter.LayoutToPropertiesConverter;
import org.gradle.launcher.cli.converter.WelcomeMessageBuildOptions;
import org.gradle.launcher.cli.internal.HelpRenderer;
import org.gradle.launcher.cli.internal.VersionInfoRenderer;
import org.gradle.launcher.configuration.AllProperties;
import org.gradle.launcher.configuration.BuildLayoutResult;
import org.gradle.launcher.configuration.InitialProperties;
import org.jspecify.annotations.Nullable;

public class DefaultCommandLineActionFactory
implements CommandLineActionFactory {
    private static final String HELP = "h";
    private static final String VERSION = "v";
    private static final String VERSION_CONTINUE = "V";

    public CommandLineActionFactory.CommandLineExecution convert(List<String> args) {
        ServiceRegistry loggingServices = this.createLoggingServices();
        DefaultLoggingConfiguration loggingConfiguration = new DefaultLoggingConfiguration();
        return new WithLogging(loggingServices, args, (LoggingConfiguration)loggingConfiguration, new ParseAndBuildAction(loggingServices, args), (Action<Throwable>)new BuildExceptionReporter((StyledTextOutputFactory)loggingServices.get(StyledTextOutputFactory.class), (LoggingConfiguration)loggingConfiguration, DefaultCommandLineActionFactory.clientMetaData(), (FailureFactory)DefaultFailureFactory.withDefaultClassifier()));
    }

    private static BuildClientMetaData clientMetaData() {
        return new DefaultBuildClientMetaData(new GradleLauncherMetaData());
    }

    @VisibleForTesting
    protected void createBuildActionFactoryActionCreator(ServiceRegistry loggingServices, ServiceRegistry basicServices, List<CommandLineActionCreator> actionCreators) {
        actionCreators.add(new BuildActionsFactory(loggingServices, basicServices));
    }

    @VisibleForTesting
    protected ServiceRegistry createLoggingServices() {
        return LoggingServiceRegistry.newCommandLineProcessLogging();
    }

    @VisibleForTesting
    public ServiceRegistry createBasicGlobalServices(ServiceRegistry loggingServices) {
        return ServiceRegistryBuilder.builder().scopeStrictly(Scope.Global.class).displayName("Basic global services").parent(loggingServices).parent(NativeServices.getInstance()).provider((ServiceRegistrationProvider)new BasicGlobalScopeServices()).build();
    }

    private static class WithLogging
    implements CommandLineActionFactory.CommandLineExecution {
        private final ServiceRegistry loggingServices;
        private final List<String> args;
        private final LoggingConfiguration loggingConfiguration;
        private final Action<ExecutionListener> action;
        private final Action<Throwable> reporter;

        WithLogging(ServiceRegistry loggingServices, List<String> args, LoggingConfiguration loggingConfiguration, Action<ExecutionListener> action, Action<Throwable> reporter) {
            this.loggingServices = loggingServices;
            this.args = args;
            this.loggingConfiguration = loggingConfiguration;
            this.action = action;
            this.reporter = reporter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(ExecutionListener executionListener) {
            BuildOptionBackedConverter welcomeMessageConverter = new BuildOptionBackedConverter((BuildOptionSet)new WelcomeMessageBuildOptions());
            BuildOptionBackedConverter loggingBuildOptions = new BuildOptionBackedConverter((BuildOptionSet)new LoggingConfigurationBuildOptions());
            InitialPropertiesConverter propertiesConverter = new InitialPropertiesConverter();
            BuildLayoutConverter buildLayoutConverter = new BuildLayoutConverter();
            LayoutToPropertiesConverter layoutToPropertiesConverter = new LayoutToPropertiesConverter(new BuildLayoutFactory());
            BuildLayoutResult buildLayout = buildLayoutConverter.defaultValues();
            CommandLineParser parser = new CommandLineParser();
            propertiesConverter.configure(parser);
            buildLayoutConverter.configure(parser);
            loggingBuildOptions.configure(parser);
            parser.allowUnknownOptions();
            parser.allowMixedSubcommandsAndOptions();
            WelcomeMessageConfiguration welcomeMessageConfiguration = new WelcomeMessageConfiguration(WelcomeMessageDisplayMode.ONCE);
            try {
                ParsedCommandLine parsedCommandLine = parser.parse(this.args);
                InitialProperties initialProperties = propertiesConverter.convert(parsedCommandLine);
                buildLayout = buildLayoutConverter.convert(initialProperties, parsedCommandLine, null);
                AllProperties properties = layoutToPropertiesConverter.convert(initialProperties, buildLayout);
                loggingBuildOptions.convert(parsedCommandLine, properties.getProperties(), (Object)this.loggingConfiguration);
                welcomeMessageConverter.convert(parsedCommandLine, properties.getProperties(), (Object)welcomeMessageConfiguration);
            }
            catch (CommandLineArgumentException parsedCommandLine) {
                // empty catch block
            }
            LoggingManagerInternal loggingManager = ((LoggingManagerFactory)this.loggingServices.get(LoggingManagerFactory.class)).createLoggingManager();
            loggingManager.setLevelInternal(this.loggingConfiguration.getLogLevel());
            loggingManager.start();
            try {
                ExceptionReportingAction exceptionReportingAction = new ExceptionReportingAction(this.reporter, (LoggingOutputInternal)loggingManager, new NativeServicesInitializingAction(buildLayout, this.loggingConfiguration, loggingManager, new WelcomeMessageAction(buildLayout, welcomeMessageConfiguration, (Action<ExecutionListener>)new DebugLoggerWarningAction(this.loggingConfiguration, this.action))));
                exceptionReportingAction.execute(executionListener);
            }
            finally {
                loggingManager.stop();
            }
        }
    }

    private class ParseAndBuildAction
    implements Action<ExecutionListener> {
        private final ServiceRegistry loggingServices;
        private final List<String> args;
        private final List<CommandLineActionCreator> actionCreators;
        private final CommandLineParser parser = new CommandLineParser();

        private ParseAndBuildAction(ServiceRegistry loggingServices, List<String> args) {
            this.loggingServices = loggingServices;
            this.args = args;
            this.actionCreators = new ArrayList<CommandLineActionCreator>();
            this.actionCreators.add(new BuiltInActionCreator());
            this.actionCreators.add(new ContinuingActionCreator());
        }

        public void execute(ExecutionListener executionListener) {
            Action<? super ExecutionListener> action;
            ServiceRegistry basicServices = DefaultCommandLineActionFactory.this.createBasicGlobalServices(this.loggingServices);
            BuildEnvironmentConfigurationConverter buildEnvironmentConfigurationConverter = new BuildEnvironmentConfigurationConverter(new BuildLayoutFactory(), (FileCollectionFactory)basicServices.get(FileCollectionFactory.class));
            buildEnvironmentConfigurationConverter.configure(this.parser);
            DefaultCommandLineActionFactory.this.createBuildActionFactoryActionCreator(this.loggingServices, basicServices, this.actionCreators);
            this.configureCreators();
            try {
                ParsedCommandLine commandLine = this.parser.parse(this.args);
                Parameters parameters = buildEnvironmentConfigurationConverter.convertParameters(commandLine, null);
                action = this.createAction(this.parser, commandLine, parameters);
            }
            catch (CommandLineArgumentException e) {
                action = new Action<ExecutionListener>(this.parser, (Exception)((Object)e), this.args);
            }
            action.execute((Object)executionListener);
        }

        private void configureCreators() {
            this.actionCreators.forEach(creator -> creator.configureCommandLineParser(this.parser));
        }

        public Action<? super ExecutionListener> createAction(CommandLineParser parser, ParsedCommandLine commandLine, Parameters parameters) {
            ArrayList<Action<? super ExecutionListener>> actions = new ArrayList<Action<? super ExecutionListener>>(2);
            for (CommandLineActionCreator actionCreator : this.actionCreators) {
                Action<? super ExecutionListener> action = actionCreator.createAction(parser, commandLine, parameters);
                if (action == null) continue;
                actions.add(action);
                if (action instanceof ContinuingAction) continue;
                break;
            }
            if (!actions.isEmpty()) {
                return Actions.composite(actions);
            }
            throw new UnsupportedOperationException("No action factory for specified command-line arguments.");
        }
    }

    private static abstract class NonParserConfiguringCommandLineActionCreator
    implements CommandLineActionCreator {
        private NonParserConfiguringCommandLineActionCreator() {
        }

        @Override
        public void configureCommandLineParser(CommandLineParser parser) {
        }
    }

    public static class ShowVersionAction
    implements Action<ExecutionListener> {
        private final Parameters parameters;

        public ShowVersionAction(Parameters parameters) {
            this.parameters = parameters;
        }

        public void execute(ExecutionListener executionListener) {
            String versionInfo = VersionInfoRenderer.renderWithLauncherJvm((String)this.parameters.getDaemonParameters().getRequestedJvmCriteria().toString());
            System.out.print(versionInfo);
        }
    }

    private static class ShowUsageAction
    implements Action<ExecutionListener> {
        private final CommandLineParser parser;
        private final ParsedCommandLine commandLine;

        public ShowUsageAction(CommandLineParser parser, ParsedCommandLine commandLine) {
            this.parser = parser;
            this.commandLine = commandLine;
        }

        public void execute(ExecutionListener executionListener) {
            String output = HelpRenderer.render((CommandLineParser)this.parser, (String)this.getSuggestedTaskSelector(), (boolean)true);
            System.out.print(output);
        }

        private @Nullable String getSuggestedTaskSelector() {
            if (!this.commandLine.getExtraArguments().isEmpty()) {
                return (String)this.commandLine.getExtraArguments().get(0);
            }
            return null;
        }
    }

    private static class CommandLineParseFailureAction
    implements Action<ExecutionListener> {
        private final CommandLineParser parser;
        private final Exception exception;
        private final List<String> args;

        public CommandLineParseFailureAction(CommandLineParser parser, Exception exception, List<String> args) {
            this.parser = parser;
            this.exception = exception;
            this.args = args;
        }

        public void execute(ExecutionListener executionListener) {
            System.err.println();
            System.err.println(this.exception.getMessage());
            String output = HelpRenderer.render((CommandLineParser)this.parser, (String)this.getSuggestedTaskSelector(), (boolean)false);
            System.err.print(output);
            executionListener.onFailure((Throwable)this.exception);
        }

        private @Nullable String getSuggestedTaskSelector() {
            for (String arg : this.args) {
                if (arg.startsWith("-")) continue;
                return arg;
            }
            return null;
        }
    }

    private static class ContinuingActionCreator
    extends NonParserConfiguringCommandLineActionCreator {
        private ContinuingActionCreator() {
        }

        public @Nullable ContinuingAction<? super ExecutionListener> createAction(CommandLineParser parser, ParsedCommandLine commandLine, Parameters parameters) {
            if (commandLine.hasOption(DefaultCommandLineActionFactory.VERSION_CONTINUE)) {
                return executionListener -> new ShowVersionAction(parameters).execute((ExecutionListener)executionListener);
            }
            return null;
        }
    }

    private static class BuiltInActionCreator
    implements CommandLineActionCreator {
        private BuiltInActionCreator() {
        }

        @Override
        public void configureCommandLineParser(CommandLineParser parser) {
            parser.option(new String[]{DefaultCommandLineActionFactory.HELP, "?", "help"}).hasDescription("Shows this help message.");
            parser.option(new String[]{DefaultCommandLineActionFactory.VERSION, "version"}).hasDescription("Print version info and exit.");
            parser.option(new String[]{DefaultCommandLineActionFactory.VERSION_CONTINUE, "show-version"}).hasDescription("Print version info and continue.");
        }

        @Override
        public @Nullable Action<? super ExecutionListener> createAction(CommandLineParser parser, ParsedCommandLine commandLine, Parameters parameters) {
            if (commandLine.hasOption(DefaultCommandLineActionFactory.HELP)) {
                return new ShowUsageAction(parser, commandLine);
            }
            if (commandLine.hasOption(DefaultCommandLineActionFactory.VERSION)) {
                return new ShowVersionAction(parameters);
            }
            return null;
        }
    }
}

