/*
 * Copyright 2025 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gradle.util.internal;

import com.google.common.base.Preconditions;
import org.jspecify.annotations.NullMarked;

import java.net.URL;
import java.util.Properties;

@NullMarked
public final class KotlinDslVersion {

    public static KotlinDslVersion current() {
        ClassLoader loader = KotlinDslVersion.class.getClassLoader();
        URL resource = loader.getResource("gradle-kotlin-dsl-versions.properties");
        Preconditions.checkNotNull(resource, "Gradle Kotlin DSL versions manifest was not found");
        Properties versions = GUtil.loadProperties(resource);
        return new KotlinDslVersion(versions.getProperty("kotlin"));
    }

    private final String kotlin;

    private KotlinDslVersion(String kotlin) {
        Preconditions.checkNotNull(kotlin, "Kotlin version was not found");
        this.kotlin = kotlin;
    }

    public String getKotlinVersion() {
        return kotlin;
    }
}
