/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.BuildToolingModelController;
import org.gradle.internal.buildtree.BuildTreeModelAction;
import org.gradle.internal.buildtree.BuildTreeModelController;
import org.gradle.internal.buildtree.BuildTreeModelCreator;
import org.gradle.internal.buildtree.BuildTreeModelTarget;
import org.gradle.internal.buildtree.IntermediateBuildActionRunner;
import org.gradle.internal.buildtree.ToolingModelRequestContext;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.tooling.provider.model.UnknownModelException;
import org.gradle.tooling.provider.model.internal.ToolingModelBuilderResultInternal;
import org.gradle.tooling.provider.model.internal.ToolingModelParameterCarrier;
import org.gradle.tooling.provider.model.internal.ToolingModelScope;
import org.jspecify.annotations.Nullable;

public class DefaultBuildTreeModelCreator
implements BuildTreeModelCreator {
    private final BuildState defaultTarget;
    private final IntermediateBuildActionRunner actionRunner;
    private final ToolingModelParameterCarrier.Factory parameterCarrierFactory;
    private final BuildStateRegistry buildStateRegistry;
    private final BuildOperationRunner buildOperationRunner;

    public DefaultBuildTreeModelCreator(BuildState defaultTarget, IntermediateBuildActionRunner actionRunner, ToolingModelParameterCarrier.Factory parameterCarrierFactory, BuildStateRegistry buildStateRegistry, BuildOperationRunner buildOperationRunner) {
        this.defaultTarget = defaultTarget;
        this.actionRunner = actionRunner;
        this.parameterCarrierFactory = parameterCarrierFactory;
        this.buildStateRegistry = buildStateRegistry;
        this.buildOperationRunner = buildOperationRunner;
    }

    @Override
    public <T> void beforeTasks(BuildTreeModelAction<? extends T> action) {
        action.beforeTasks(new DefaultBuildTreeModelController());
    }

    @Override
    public <T> T fromBuildModel(BuildTreeModelAction<? extends T> action) {
        return action.fromBuildModel(new DefaultBuildTreeModelController());
    }

    private class DefaultBuildTreeModelController
    implements BuildTreeModelController {
        private DefaultBuildTreeModelController() {
        }

        @Override
        public GradleInternal getConfiguredModel() {
            return DefaultBuildTreeModelCreator.this.defaultTarget.withToolingModels(false, BuildToolingModelController::getConfiguredModel);
        }

        @Override
        public ToolingModelBuilderResultInternal getModel(final BuildTreeModelTarget target, final ToolingModelRequestContext modelRequestContext) throws UnknownModelException {
            return (ToolingModelBuilderResultInternal)DefaultBuildTreeModelCreator.this.buildOperationRunner.call((CallableBuildOperation)new CallableBuildOperation<ToolingModelBuilderResultInternal>(){

                public @Nullable ToolingModelBuilderResultInternal call(BuildOperationContext context) {
                    ToolingModelScope scope = DefaultBuildTreeModelController.this.locateBuilderForTarget(target, modelRequestContext);
                    return scope.getModel(modelRequestContext, modelRequestContext.getParameter().map(DefaultBuildTreeModelCreator.this.parameterCarrierFactory::createCarrier).orElse(null));
                }

                public BuildOperationDescriptor.Builder description() {
                    String targetDescription = target.describeTargetScope();
                    String modelName = modelRequestContext.getModelName();
                    return BuildOperationDescriptor.displayName((String)("Fetch model '" + modelName + "' for " + targetDescription)).progressDisplayName("Fetching model '" + modelName + "' for " + targetDescription);
                }
            });
        }

        @Override
        public boolean queryModelActionsRunInParallel() {
            return DefaultBuildTreeModelCreator.this.actionRunner.isParallel();
        }

        @Override
        public <T> @Nullable List<T> runQueryModelActions(final List<Supplier<T>> actions) {
            return (List)DefaultBuildTreeModelCreator.this.buildOperationRunner.call(new CallableBuildOperation<List<T>>(){

                public List<T> call(BuildOperationContext context) {
                    return DefaultBuildTreeModelCreator.this.actionRunner.run(actions);
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)String.format("Run nested tooling build actions (%d)", actions.size()));
                }
            });
        }

        private ToolingModelScope locateBuilderForTarget(BuildTreeModelTarget target, ToolingModelRequestContext toolingModelContext) {
            if (target instanceof BuildTreeModelTarget.Default) {
                return this.locateBuilderForDefaultTarget(toolingModelContext);
            }
            if (target instanceof BuildTreeModelTarget.Build) {
                return this.locateBuilderForBuildTarget((BuildTreeModelTarget.Build)target, toolingModelContext);
            }
            if (target instanceof BuildTreeModelTarget.Project) {
                return this.locateBuilderForProjectTarget((BuildTreeModelTarget.Project)target, toolingModelContext);
            }
            throw new IllegalStateException("Unknown target: " + target);
        }

        private ToolingModelScope locateBuilderForDefaultTarget(ToolingModelRequestContext toolingModelContext) {
            return this.locateBuilderForBuildTarget(DefaultBuildTreeModelCreator.this.defaultTarget, toolingModelContext);
        }

        private ToolingModelScope locateBuilderForProjectTarget(BuildTreeModelTarget.Project projectTarget, ToolingModelRequestContext toolingModelContext) {
            BuildState build = this.findBuild(projectTarget.getBuildRootDir());
            ProjectState project = this.findProject(build, projectTarget);
            return this.locateBuilderForProjectTarget(project, toolingModelContext);
        }

        private ToolingModelScope locateBuilderForBuildTarget(BuildTreeModelTarget.Build buildTarget, ToolingModelRequestContext toolingModelContext) {
            BuildState build = this.findBuild(buildTarget.getBuildRootDir());
            return this.locateBuilderForBuildTarget(build, toolingModelContext);
        }

        private ToolingModelScope locateBuilderForBuildTarget(BuildState target, ToolingModelRequestContext toolingModelContext) {
            return target.withToolingModels(toolingModelContext.inResilientContext(), controller -> controller.locateBuilderForTarget(toolingModelContext));
        }

        private ToolingModelScope locateBuilderForProjectTarget(ProjectState target, ToolingModelRequestContext toolingModelContext) {
            return target.getOwner().withToolingModels(toolingModelContext.inResilientContext(), controller -> controller.locateBuilderForTarget(target, toolingModelContext));
        }

        private BuildState findBuild(File targetBuildRootDir) {
            AtomicReference<@Nullable V> match = new AtomicReference();
            DefaultBuildTreeModelCreator.this.buildStateRegistry.visitBuilds(buildState -> {
                if (buildState.isImportableBuild() && buildState.getBuildRootDir().equals(targetBuildRootDir)) {
                    match.set(buildState);
                }
            });
            BuildState buildState2 = (BuildState)match.get();
            if (buildState2 != null) {
                return buildState2;
            }
            throw new IllegalArgumentException(targetBuildRootDir + " is not included in this build");
        }

        private ProjectState findProject(BuildState build, BuildTreeModelTarget.Project project) {
            if (!build.isProjectsLoaded()) {
                build.ensureProjectsLoaded();
            }
            return build.getProjects().getProject(project.getProjectPath());
        }
    }
}

