/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.internal;

import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.Properties;
import org.gradle.util.internal.GUtil;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class KotlinDslVersion {
    private final String kotlin;

    public static KotlinDslVersion current() {
        ClassLoader loader = KotlinDslVersion.class.getClassLoader();
        URL resource = loader.getResource("gradle-kotlin-dsl-versions.properties");
        Preconditions.checkNotNull((Object)resource, (Object)"Gradle Kotlin DSL versions manifest was not found");
        Properties versions = GUtil.loadProperties(resource);
        return new KotlinDslVersion(versions.getProperty("kotlin"));
    }

    private KotlinDslVersion(String kotlin) {
        Preconditions.checkNotNull((Object)kotlin, (Object)"Kotlin version was not found");
        this.kotlin = kotlin;
    }

    public String getKotlinVersion() {
        return this.kotlin;
    }
}

