/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.impl;

import java.io.Closeable;
import java.io.File;
import org.gradle.cache.IndexedCache;
import org.gradle.cache.IndexedCacheParameters;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.internal.execution.history.OutputFilesRepository;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.SnapshotVisitResult;

public class DefaultOutputFilesRepository
implements OutputFilesRepository,
Closeable {
    private final PersistentCache cacheAccess;
    private final IndexedCache<String, OutputKind> outputFiles;

    public DefaultOutputFilesRepository(PersistentCache cacheAccess, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory) {
        this.cacheAccess = cacheAccess;
        this.outputFiles = cacheAccess.createIndexedCache(DefaultOutputFilesRepository.cacheParameters(inMemoryCacheDecoratorFactory));
    }

    @Override
    public boolean isGeneratedByGradle(File file) {
        File absoluteFile = file.getAbsoluteFile();
        return this.containsFilesGeneratedByGradle(absoluteFile) || this.isContainedInAnOutput(absoluteFile);
    }

    private boolean isContainedInAnOutput(File absoluteFile) {
        for (File currentFile = absoluteFile; currentFile != null; currentFile = currentFile.getParentFile()) {
            if (this.outputFiles.getIfPresent((Object)currentFile.getPath()) != OutputKind.OUTPUT) continue;
            return true;
        }
        return false;
    }

    private boolean containsFilesGeneratedByGradle(File absoluteFile) {
        return this.outputFiles.getIfPresent((Object)absoluteFile.getPath()) != null;
    }

    @Override
    public void recordOutputs(Iterable<? extends FileSystemSnapshot> outputSnapshots) {
        for (FileSystemSnapshot fileSystemSnapshot : outputSnapshots) {
            fileSystemSnapshot.accept(entrySnapshot -> {
                entrySnapshot.accept(new FileSystemLocationSnapshot.FileSystemLocationSnapshotVisitor(){

                    public void visitDirectory(DirectorySnapshot directorySnapshot) {
                        this.recordOutputSnapshot((FileSystemLocationSnapshot)directorySnapshot);
                    }

                    public void visitRegularFile(RegularFileSnapshot fileSnapshot) {
                        this.recordOutputSnapshot((FileSystemLocationSnapshot)fileSnapshot);
                    }

                    private void recordOutputSnapshot(FileSystemLocationSnapshot snapshot) {
                        String outputPath = snapshot.getAbsolutePath();
                        File outputFile = new File(outputPath);
                        DefaultOutputFilesRepository.this.outputFiles.put((Object)outputPath, (Object)OutputKind.OUTPUT);
                        for (File outputFileParent = outputFile.getParentFile(); outputFileParent != null; outputFileParent = outputFileParent.getParentFile()) {
                            String parentPath = outputFileParent.getPath();
                            if (DefaultOutputFilesRepository.this.outputFiles.getIfPresent((Object)parentPath) != null) break;
                            DefaultOutputFilesRepository.this.outputFiles.put((Object)parentPath, (Object)OutputKind.PARENT_OF_OUTPUT);
                        }
                    }
                });
                return SnapshotVisitResult.SKIP_SUBTREE;
            });
        }
    }

    private static IndexedCacheParameters<String, OutputKind> cacheParameters(InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory) {
        return IndexedCacheParameters.of((String)"outputFiles", String.class, OutputKind.class).withCacheDecorator(inMemoryCacheDecoratorFactory.decorator(100000, true));
    }

    @Override
    public void close() {
        this.cacheAccess.close();
    }

    static enum OutputKind {
        OUTPUT,
        PARENT_OF_OUTPUT;

    }
}

