/*
 * Copyright 2023 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.internal.enterprise

import org.gradle.integtests.fixtures.executer.GradleExecuter
import org.gradle.plugin.management.internal.autoapply.AutoAppliedDevelocityPlugin
import org.gradle.test.fixtures.file.TestFile
import org.gradle.test.fixtures.maven.MavenFileRepository
import org.gradle.test.fixtures.plugin.PluginBuilder

class DevelocityPluginCheckInFixture extends BaseBuildScanPluginCheckInFixture {

    DevelocityPluginCheckInFixture(TestFile projectDir, MavenFileRepository mavenRepo, GradleExecuter pluginBuildExecuter) {
        super(
            projectDir,
            mavenRepo,
            pluginBuildExecuter,
            AutoAppliedDevelocityPlugin.ID.id,
            'com.gradle.develocity.agent.gradle',
            'DevelocityPlugin',
            AutoAppliedDevelocityPlugin.NAME
        )
    }

    @Override
    String configureExtension(PluginBuilder builder) {
        builder.file('src/main/groovy/com/gradle/develocity/agent/gradle/DevelocityConfiguration.groovy') << """
package com.gradle.develocity.agent.gradle

import org.gradle.api.provider.Property

abstract class DevelocityConfiguration {
    abstract Property<String> getServer()
}
"""
        return """
            def dvExtension = settings.getExtensions().create("develocity", com.gradle.develocity.agent.gradle.DevelocityConfiguration.class);

            settings.gradle.settingsEvaluated {
                println "develocityExtension.server = \${dvExtension.getServer().getOrElse("unset")}"
            }
"""
    }

    void assertExtensionDevelocityUrl(String output, String develocityUrl) {
        assert output.contains("develocityExtension.server = $develocityUrl")
    }

}
