/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.testing;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.tasks.testing.report.generic.GenericHtmlTestReportGenerator;
import org.gradle.api.internal.tasks.testing.report.generic.MetadataRendererRegistry;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.instrumentation.api.annotations.ReplacedAccessor;
import org.gradle.internal.instrumentation.api.annotations.ReplacedDeprecation;
import org.gradle.internal.instrumentation.api.annotations.ReplacesEagerProperty;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not made cacheable, yet")
public abstract class TestReport
extends DefaultTask {
    @Inject
    protected abstract ObjectFactory getObjectFactory();

    @Inject
    @Deprecated
    protected abstract BuildOperationRunner getBuildOperationRunner();

    @Inject
    @Deprecated
    protected abstract BuildOperationExecutor getBuildOperationExecutor();

    @Deprecated
    @Internal
    protected MetadataRendererRegistry getMetadataRendererRegistry() {
        return new MetadataRendererRegistry();
    }

    @OutputDirectory
    @ReplacesEagerProperty(replacedAccessors={@ReplacedAccessor(value=ReplacedAccessor.AccessorType.GETTER, name="getDestinationDir"), @ReplacedAccessor(value=ReplacedAccessor.AccessorType.SETTER, name="setDestinationDir")}, deprecation=@ReplacedDeprecation(removedIn=ReplacedDeprecation.RemovedIn.GRADLE9))
    public abstract DirectoryProperty getDestinationDirectory();

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getTestResults();

    @TaskAction
    void generateReport() {
        try {
            ArrayList<Path> resultDirsAsPaths = new ArrayList<Path>(this.getTestResults().getFiles().size());
            for (File resultDir : this.getTestResults().getFiles()) {
                if (!resultDir.exists()) continue;
                resultDirsAsPaths.add(resultDir.toPath());
            }
            Path reportsDir = ((Directory)this.getDestinationDirectory().get()).getAsFile().toPath();
            ((GenericHtmlTestReportGenerator)this.getObjectFactory().newInstance(GenericHtmlTestReportGenerator.class, new Object[]{reportsDir})).generate(resultDirsAsPaths);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not write test report for results in " + this.getTestResults().getFiles(), e);
        }
    }
}

