/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.report.generic.GenericHtmlTestReportGenerator;
import org.gradle.api.internal.tasks.testing.results.TestExecutionResultsListener;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.problems.buildtree.ProblemReporter;
import org.jspecify.annotations.NullMarked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
@ServiceScope(value={Scope.BuildTree.class})
public class AggregateTestEventReporter
implements ProblemReporter,
TestExecutionResultsListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregateTestEventReporter.class);
    private final ObjectFactory objectFactory;
    private final AtomicInteger numFailedResults = new AtomicInteger(0);
    private final Map<TestDescriptorInternal, Path> results = new ConcurrentHashMap<TestDescriptorInternal, Path>();

    @Inject
    public AggregateTestEventReporter(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public String getId() {
        return "aggregate-test-results";
    }

    @Override
    public void executionResultsAvailable(TestDescriptorInternal rootDescriptor, Path binaryResultsDir, boolean hasTestFailures) {
        this.results.put(rootDescriptor, binaryResultsDir);
        if (hasTestFailures) {
            this.numFailedResults.incrementAndGet();
        }
    }

    public void report(File reportDir, ProblemReporter.ProblemConsumer validationFailures) {
        Path reportLocation = reportDir.toPath().resolve("reports").resolve("aggregate-test-results");
        if (!this.results.isEmpty()) {
            Path reportIndexFile = this.generateTestReport(reportLocation);
            if (this.numFailedResults.get() > 1) {
                AggregateTestEventReporter.emitReport(reportIndexFile);
            }
        } else if (Files.exists(reportLocation, new LinkOption[0])) {
            try {
                FileUtils.deleteDirectory((File)reportLocation.toFile());
            }
            catch (IOException e) {
                LOGGER.debug("Failed to delete stale aggregate report directory", (Throwable)e);
            }
        }
    }

    private Path generateTestReport(Path reportDirectory) {
        ArrayList<Path> sortedResults = new ArrayList<Path>(this.results.values());
        sortedResults.sort(Comparator.naturalOrder());
        return ((GenericHtmlTestReportGenerator)this.objectFactory.newInstance(GenericHtmlTestReportGenerator.class, new Object[]{reportDirectory})).generate(sortedResults);
    }

    private static void emitReport(Path reportIndexFile) {
        String url = new ConsoleRenderer().asClickableFileUrl(reportIndexFile.toFile());
        LOGGER.warn("Aggregate test results: {}", (Object)url);
    }
}

