/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import java.io.IOException;
import java.time.Duration;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.execution.Execution;
import org.gradle.internal.execution.ExecutionProblemHandler;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.InputVisitor;
import org.gradle.internal.execution.MutableUnitOfWork;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkInputListeners;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.history.ExecutionInputState;
import org.gradle.internal.execution.history.ExecutionOutputState;
import org.gradle.internal.execution.history.OutputsCleaner;
import org.gradle.internal.execution.steps.CachingResult;
import org.gradle.internal.execution.steps.MutableStep;
import org.gradle.internal.execution.steps.PreviousExecutionContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.properties.InputBehavior;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.SnapshotUtil;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipEmptyMutableWorkStep
extends MutableStep<PreviousExecutionContext, CachingResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipEmptyMutableWorkStep.class);
    private final ExecutionProblemHandler problemHandler;
    private final WorkInputListeners workInputListeners;
    private final OutputChangeListener outputChangeListener;
    private final Supplier<OutputsCleaner> outputsCleanerSupplier;
    protected final Step<? super PreviousExecutionContext, ? extends CachingResult> delegate;

    public SkipEmptyMutableWorkStep(ExecutionProblemHandler problemHandler, OutputChangeListener outputChangeListener, WorkInputListeners workInputListeners, Supplier<OutputsCleaner> outputsCleanerSupplier, Step<? super PreviousExecutionContext, ? extends CachingResult> delegate) {
        this.problemHandler = problemHandler;
        this.workInputListeners = workInputListeners;
        this.outputChangeListener = outputChangeListener;
        this.outputsCleanerSupplier = outputsCleanerSupplier;
        this.delegate = delegate;
    }

    @Override
    protected CachingResult executeMutable(MutableUnitOfWork work, PreviousExecutionContext context) {
        ImmutableSortedMap<String, ValueSnapshot> knownValueSnapshots;
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> knownFileFingerprints = context.getInputFileProperties();
        InputFingerprinter.Result newInputs = this.fingerprintPrimaryInputs(work, context, knownFileFingerprints, knownValueSnapshots = context.getInputProperties());
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> sourceFileProperties = newInputs.getFileFingerprints();
        if (sourceFileProperties.isEmpty()) {
            return this.executeWithNonEmptySources(work, context);
        }
        if (SkipEmptyMutableWorkStep.hasEmptySources(sourceFileProperties, newInputs.getPropertiesRequiringIsEmptyCheck(), work)) {
            return this.skipExecutionWithEmptySources(work, context);
        }
        return this.executeWithNonEmptySources(work, this.recreateContextWithNewInputFiles(context, newInputs.getAllFileFingerprints()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean hasEmptySources(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> sourceFileProperties, ImmutableSet<String> propertiesRequiringIsEmptyCheck, UnitOfWork work) {
        if (propertiesRequiringIsEmptyCheck.isEmpty()) {
            return sourceFileProperties.values().stream().allMatch(CurrentFileCollectionFingerprint::isEmpty);
        }
        if (!SkipEmptyMutableWorkStep.hasEmptyFingerprints(sourceFileProperties, propertyName -> !propertiesRequiringIsEmptyCheck.contains(propertyName))) return false;
        if (!SkipEmptyMutableWorkStep.hasEmptyInputFileCollections(work, arg_0 -> propertiesRequiringIsEmptyCheck.contains(arg_0))) return false;
        return true;
    }

    private static boolean hasEmptyFingerprints(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> sourceFileProperties, Predicate<String> propertyNameFilter) {
        return sourceFileProperties.entrySet().stream().filter(entry -> propertyNameFilter.test((String)entry.getKey())).map(Map.Entry::getValue).allMatch(CurrentFileCollectionFingerprint::isEmpty);
    }

    private static boolean hasEmptyInputFileCollections(UnitOfWork work, Predicate<String> propertyNameFilter) {
        EmptyCheckingVisitor visitor = new EmptyCheckingVisitor(propertyNameFilter);
        work.visitMutableInputs(visitor);
        return visitor.isAllEmpty();
    }

    protected PreviousExecutionContext recreateContextWithNewInputFiles(PreviousExecutionContext context, final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFiles) {
        return new PreviousExecutionContext(context){

            @Override
            public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getInputFileProperties() {
                return inputFiles;
            }
        };
    }

    protected ImmutableSortedMap<String, ValueSnapshot> getKnownInputProperties(PreviousExecutionContext context) {
        return context.getPreviousExecutionState().map(ExecutionInputState::getInputProperties).orElse(ImmutableSortedMap.of());
    }

    protected ImmutableSortedMap<String, ? extends FileCollectionFingerprint> getKnownInputFileProperties(PreviousExecutionContext context) {
        return context.getPreviousExecutionState().map(ExecutionInputState::getInputFileProperties).orElse(ImmutableSortedMap.of());
    }

    protected CachingResult performSkip(UnitOfWork work, PreviousExecutionContext context) {
        Execution.ExecutionOutcome skipOutcome;
        ImmutableSortedMap outputFilesAfterPreviousExecution = context.getPreviousExecutionState().map(ExecutionOutputState::getOutputFilesProducedByWork).orElse(ImmutableSortedMap.of());
        Timer timer = Time.startTimer();
        String executionReason = null;
        if (outputFilesAfterPreviousExecution.isEmpty()) {
            LOGGER.info("Skipping {} as it has no source files and no previous output files.", (Object)work.getDisplayName());
            skipOutcome = Execution.ExecutionOutcome.SHORT_CIRCUITED;
        } else {
            boolean didWork = this.cleanPreviousOutputs((Map<String, FileSystemSnapshot>)outputFilesAfterPreviousExecution);
            if (didWork) {
                LOGGER.info("Cleaned previous output of {} as it has no source files.", (Object)work.getDisplayName());
                skipOutcome = Execution.ExecutionOutcome.EXECUTED_NON_INCREMENTALLY;
                executionReason = "Cleaned previous output";
            } else {
                skipOutcome = Execution.ExecutionOutcome.SHORT_CIRCUITED;
            }
        }
        Duration duration = skipOutcome == Execution.ExecutionOutcome.SHORT_CIRCUITED ? Duration.ZERO : Duration.ofMillis(timer.getElapsedMillis());
        return CachingResult.shortcutResult(duration, Execution.skipped(skipOutcome, work), null, executionReason, null);
    }

    private boolean cleanPreviousOutputs(Map<String, FileSystemSnapshot> outputFileSnapshots) {
        OutputsCleaner outputsCleaner = this.outputsCleanerSupplier.get();
        for (FileSystemSnapshot outputFileSnapshot : outputFileSnapshots.values()) {
            try {
                this.outputChangeListener.invalidateCachesFor(SnapshotUtil.rootIndex((FileSystemSnapshot)outputFileSnapshot).keySet());
                outputsCleaner.cleanupOutputs(outputFileSnapshot);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        return outputsCleaner.getDidWork();
    }

    private InputFingerprinter.Result fingerprintPrimaryInputs(UnitOfWork work, PreviousExecutionContext context, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> knownFileFingerprints, ImmutableSortedMap<String, ValueSnapshot> knownValueSnapshots) {
        return work.getInputFingerprinter().fingerprintInputProperties(this.getKnownInputProperties(context), this.getKnownInputFileProperties(context), knownValueSnapshots, knownFileFingerprints, visitor -> work.visitMutableInputs(new InputVisitor(){
            final /* synthetic */ InputVisitor val$visitor;
            {
                this.val$visitor = inputVisitor;
            }

            @Override
            public void visitInputFileProperty(String propertyName, InputBehavior behavior, InputVisitor.InputFileValueSupplier value) {
                if (behavior.shouldSkipWhenEmpty()) {
                    this.val$visitor.visitInputFileProperty(propertyName, behavior, value);
                }
            }
        }), work.getInputDependencyChecker(context.getValidationContext()));
    }

    private CachingResult skipExecutionWithEmptySources(UnitOfWork work, PreviousExecutionContext context) {
        WorkValidationContext validationContext = context.getValidationContext();
        work.checkOutputDependencies(validationContext);
        this.problemHandler.handleReportedProblems(context.getIdentity(), work, validationContext);
        CachingResult result = this.performSkip(work, context);
        this.workInputListeners.broadcastFileSystemInputsOf(work, EnumSet.of(InputBehavior.PRIMARY));
        return result;
    }

    private CachingResult executeWithNonEmptySources(UnitOfWork work, PreviousExecutionContext context) {
        this.workInputListeners.broadcastFileSystemInputsOf(work, EnumSet.allOf(InputBehavior.class));
        return this.delegate.execute(work, context);
    }

    private static class EmptyCheckingVisitor
    implements InputVisitor {
        private final Predicate<String> propertyNameFilter;
        private boolean allEmpty = true;

        public EmptyCheckingVisitor(Predicate<String> propertyNameFilter) {
            this.propertyNameFilter = propertyNameFilter;
        }

        @Override
        public void visitInputFileProperty(String propertyName, InputBehavior behavior, InputVisitor.InputFileValueSupplier value) {
            if (this.propertyNameFilter.test(propertyName)) {
                this.allEmpty = this.allEmpty && value.getFiles().isEmpty();
            }
        }

        public boolean isAllEmpty() {
            return this.allEmpty;
        }
    }
}

