/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.enterprise.impl;

import org.gradle.StartParameter;
import org.gradle.api.internal.BuildType;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.internal.enterprise.GradleEnterprisePluginConfig;
import org.gradle.internal.enterprise.impl.GradleEnterprisePluginAutoAppliedStatus;
import org.jspecify.annotations.Nullable;

public class DefaultGradleEnterprisePluginConfig
implements GradleEnterprisePluginConfig {
    private final GradleEnterprisePluginConfig.BuildScanRequest buildScanRequest;
    private final boolean taskExecutingBuild;
    private final boolean autoApplied;
    private final @Nullable String develocityUrl;

    public DefaultGradleEnterprisePluginConfig(StartParameter startParameter, BuildType buildType, GradleEnterprisePluginAutoAppliedStatus autoAppliedStatus) {
        this.buildScanRequest = this.buildScanRequest(startParameter);
        this.taskExecutingBuild = buildType == BuildType.TASKS;
        this.autoApplied = autoAppliedStatus.isAutoApplied();
        this.develocityUrl = ((StartParameterInternal)startParameter).getDevelocityUrl();
    }

    @Override
    public GradleEnterprisePluginConfig.BuildScanRequest getBuildScanRequest() {
        return this.buildScanRequest;
    }

    @Override
    public boolean isTaskExecutingBuild() {
        return this.taskExecutingBuild;
    }

    @Override
    public boolean isAutoApplied() {
        return this.autoApplied;
    }

    @Override
    public @Nullable String getDevelocityUrl() {
        return this.develocityUrl;
    }

    private GradleEnterprisePluginConfig.BuildScanRequest buildScanRequest(StartParameter startParameter) {
        if (startParameter.isNoBuildScan()) {
            return GradleEnterprisePluginConfig.BuildScanRequest.SUPPRESSED;
        }
        if (startParameter.isBuildScan()) {
            return GradleEnterprisePluginConfig.BuildScanRequest.REQUESTED;
        }
        return GradleEnterprisePluginConfig.BuildScanRequest.NONE;
    }
}

