/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.file.FileFactory;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.jvm.toolchain.internal.JavaToolchain;
import org.gradle.jvm.toolchain.internal.JavaToolchainInput;

public class SpecificExecutableJavaToolchain
extends JavaToolchain {
    private final RegularFile javaExecutable;

    public SpecificExecutableJavaToolchain(JvmInstallationMetadata metadata, FileFactory fileFactory, JavaToolchainInput input, boolean isFallbackToolchain, File javaExecutableFile) {
        super(metadata, fileFactory, input, isFallbackToolchain);
        this.javaExecutable = fileFactory.file(javaExecutableFile);
    }

    @Override
    public RegularFile findExecutable(String toolName) {
        if (toolName.equals("java")) {
            return this.javaExecutable;
        }
        throw new UnsupportedOperationException("This toolchain only supports retrieving the 'java' executable at " + this.javaExecutable.getAsFile().getAbsolutePath() + ".  It cannot be used to resolve the '" + toolName + "' executable.");
    }
}

