/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import com.google.common.base.MoreObjects;
import java.io.File;
import java.util.Objects;
import javax.inject.Inject;
import org.gradle.api.internal.provider.PropertyFactory;
import org.gradle.jvm.toolchain.internal.DefaultToolchainSpec;
import org.gradle.jvm.toolchain.internal.JavaToolchainSpecInternal;
import org.gradle.jvm.toolchain.internal.SpecificInstallationToolchainSpec;

public class SpecificExecutableToolchainSpec
extends DefaultToolchainSpec {
    private final File javaExecutable;

    @Inject
    public SpecificExecutableToolchainSpec(PropertyFactory propertyFactory, File javaExecutable) {
        super(propertyFactory);
        this.javaExecutable = javaExecutable;
    }

    @Override
    public SpecificInstallationToolchainSpec.Key toKey() {
        return new SpecificInstallationToolchainSpec.Key(this.javaExecutable);
    }

    @Override
    public boolean isConfigured() {
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public File getJavaHome() {
        return this.javaExecutable.getParentFile().getParentFile();
    }

    @Override
    public String getDisplayName() {
        return MoreObjects.toStringHelper((String)"SpecificToolchain ").add("javaExecutable", (Object)this.javaExecutable).toString();
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    public File getJavaExecutable() {
        return this.javaExecutable;
    }

    public static class Key
    implements JavaToolchainSpecInternal.Key {
        private final File javaExecutable;

        public Key(File javaExecutable) {
            this.javaExecutable = javaExecutable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.javaExecutable, key.javaExecutable);
        }

        public int hashCode() {
            return Objects.hash(this.javaExecutable);
        }
    }
}

