/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.DefaultBuildToolingModelController;
import org.gradle.internal.buildtree.ToolingModelRequestContext;
import org.gradle.tooling.provider.model.UnknownModelException;
import org.gradle.tooling.provider.model.internal.ToolingModelBuilderLookup;
import org.gradle.tooling.provider.model.internal.ToolingModelScope;

public class ResilientBuildToolingModelController
extends DefaultBuildToolingModelController {
    private static final Set<String> RESILIENT_MODELS = ImmutableSet.of((Object)"org.gradle.tooling.model.kotlin.dsl.KotlinDslScriptsModel");

    public ResilientBuildToolingModelController(BuildState buildState, BuildLifecycleController buildController, ToolingModelBuilderLookup buildScopeLookup) {
        super(buildState, buildController, buildScopeLookup);
    }

    @Override
    protected void configureProjectsForModel(ProjectState target, String modelName) {
        try {
            super.configureProjectsForModel(target, modelName);
        }
        catch (GradleException e) {
            ResilientBuildToolingModelController.rethrowExceptionIfNotResilientModel(target, modelName, e);
        }
    }

    private static void rethrowExceptionIfNotResilientModel(ProjectState target, String modelName, GradleException e) {
        if (!target.isCreated()) {
            throw e;
        }
        if (!RESILIENT_MODELS.contains(modelName)) {
            throw e;
        }
    }

    @Override
    protected ToolingModelScope doLocate(ProjectState target, ToolingModelRequestContext toolingModelContext) {
        return new ResilientProjectToolingScope(target, toolingModelContext);
    }

    private static class ResilientProjectToolingScope
    extends DefaultBuildToolingModelController.ProjectToolingScope {
        public ResilientProjectToolingScope(ProjectState target, ToolingModelRequestContext toolingModelContext) {
            super(target, toolingModelContext.getModelName(), toolingModelContext.getParameter().isPresent());
        }

        @Override
        ToolingModelBuilderLookup.Builder locateBuilder() throws UnknownModelException {
            try {
                this.targetProject.ensureConfigured();
            }
            catch (GradleException e) {
                ResilientBuildToolingModelController.rethrowExceptionIfNotResilientModel(this.targetProject, this.modelName, e);
            }
            ProjectInternal project = this.targetProject.getMutableModelEvenAfterFailure();
            ToolingModelBuilderLookup lookup = (ToolingModelBuilderLookup)project.getServices().get(ToolingModelBuilderLookup.class);
            return lookup.locateForClientOperation(this.modelName, this.parameter, this.targetProject, project);
        }
    }
}

