/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.artifacts.DefaultBuildIdentifier;
import org.gradle.api.internal.project.HoldsProjectState;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.specs.Spec;
import org.gradle.execution.BuildWorkExecutor;
import org.gradle.execution.EntryTaskSelector;
import org.gradle.execution.TaskSelection;
import org.gradle.execution.plan.BuildWorkPlan;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.execution.plan.FinalizedExecutionPlan;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.QueryableExecutionPlan;
import org.gradle.execution.plan.ScheduledWork;
import org.gradle.internal.Describables;
import org.gradle.internal.Pair;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildModelController;
import org.gradle.internal.build.BuildModelLifecycleListener;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.BuildToolingModelController;
import org.gradle.internal.build.BuildToolingModelControllerFactory;
import org.gradle.internal.build.BuildWorkPreparer;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.exception.ExceptionAnalyser;
import org.gradle.internal.model.StateTransitionController;
import org.gradle.internal.model.StateTransitionControllerFactory;
import org.gradle.util.Path;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

public class DefaultBuildLifecycleController
implements BuildLifecycleController {
    private static final ImmutableList<State> CONFIGURATION_STATES = ImmutableList.of((Object)State.Configure, (Object)State.TaskSchedule, (Object)State.ReadyToRun);
    private final ExceptionAnalyser exceptionAnalyser;
    private final BuildListener buildListener;
    private final BuildModelLifecycleListener buildModelLifecycleListener;
    private final BuildWorkPreparer workPreparer;
    private final BuildWorkExecutor workExecutor;
    private final BuildToolingModelControllerFactory toolingModelControllerFactory;
    private final BuildModelController modelController;
    private final StateTransitionController<State> buildState;
    private final GradleInternal gradle;
    private boolean hasTasks;
    private boolean hasFiredBeforeModelDiscarded;

    public DefaultBuildLifecycleController(GradleInternal gradle, BuildModelController buildModelController, ExceptionAnalyser exceptionAnalyser, BuildListener buildListener, BuildModelLifecycleListener buildModelLifecycleListener, BuildWorkPreparer workPreparer, BuildWorkExecutor workExecutor, BuildToolingModelControllerFactory toolingModelControllerFactory, StateTransitionControllerFactory controllerFactory) {
        this.gradle = gradle;
        this.modelController = buildModelController;
        this.exceptionAnalyser = exceptionAnalyser;
        this.buildListener = buildListener;
        this.workPreparer = workPreparer;
        this.workExecutor = workExecutor;
        this.buildModelLifecycleListener = buildModelLifecycleListener;
        this.toolingModelControllerFactory = toolingModelControllerFactory;
        this.buildState = controllerFactory.newController(Describables.of((Object)"state of", (Object)this.targetBuild().getDisplayName()), State.Configure);
    }

    @Override
    public GradleInternal getGradle() {
        this.buildState.assertNotInState(State.Finished);
        return this.gradle;
    }

    @Override
    public void loadSettings() {
        this.buildState.notInState(State.Finished, this.modelController::getLoadedSettings);
    }

    @Override
    public <T> T withSettings(Function<? super SettingsInternal, T> action) {
        return (T)this.buildState.notInState(State.Finished, () -> action.apply(this.modelController.getLoadedSettings()));
    }

    @Override
    public void configureProjects() {
        this.buildState.notInState(State.Finished, this.modelController::getConfiguredModel);
    }

    @Override
    public <T> T withProjectsConfigured(Function<? super GradleInternal, T> action) {
        return (T)this.buildState.notInState(State.Finished, () -> action.apply(this.modelController.getConfiguredModel()));
    }

    @Override
    public void resetModel() {
        this.buildState.restart(State.ReadyToReset, State.Configure, () -> {
            this.gradle.resetState();
            for (HoldsProjectState service : this.gradle.getServices().getAll(HoldsProjectState.class)) {
                service.discardAll();
            }
        });
    }

    @Override
    public ExecutionResult<Void> beforeModelReset() {
        return this.buildState.transition((List<State>)CONFIGURATION_STATES, State.ReadyToReset, failures -> this.fireBeforeModelDiscarded(false));
    }

    @Override
    public ExecutionResult<Void> beforeModelDiscarded(boolean failed) {
        return this.buildState.transition(State.BuildFinishHooks, State.Finished, failures -> this.fireBeforeModelDiscarded(failed));
    }

    private ExecutionResult<Void> fireBeforeModelDiscarded(boolean failed) {
        if (this.hasFiredBeforeModelDiscarded) {
            return ExecutionResult.succeeded();
        }
        this.hasFiredBeforeModelDiscarded = true;
        return ExecutionResult.maybeFailing(() -> this.buildModelLifecycleListener.beforeModelDiscarded(this.gradle, failed));
    }

    @Override
    public GradleInternal getConfiguredBuild() {
        return this.buildState.notInStateIgnoreOtherThreads(State.Finished, this.modelController::getConfiguredModel);
    }

    @Override
    public void prepareToScheduleTasks() {
        this.buildState.maybeTransition(State.Configure, State.TaskSchedule, () -> {
            this.hasTasks = true;
            this.modelController.prepareToScheduleTasks();
        });
    }

    @Override
    public BuildWorkPlan newWorkGraph() {
        ExecutionPlan plan = this.workPreparer.newExecutionPlan();
        return new DefaultBuildWorkPlan(this, plan);
    }

    @Override
    public void populateWorkGraph(BuildWorkPlan plan, Consumer<? super BuildLifecycleController.WorkGraphBuilder> action) {
        DefaultBuildWorkPlan workPlan = this.unpack(plan);
        workPlan.empty = false;
        this.buildState.inState(State.TaskSchedule, () -> this.workPreparer.populateWorkGraph(this.gradle, workPlan.plan, dest -> action.accept(new DefaultWorkGraphBuilder((ExecutionPlan)dest))));
    }

    @Override
    public void finalizeWorkGraph(BuildWorkPlan plan) {
        DefaultBuildWorkPlan workPlan = this.unpack(plan);
        if (workPlan.empty) {
            return;
        }
        this.buildState.transition(State.TaskSchedule, State.ReadyToRun, () -> {
            for (Consumer handler : workPlan.handlers) {
                workPlan.plan.onComplete(handler);
            }
            workPlan.finalizedPlan = this.workPreparer.finalizeWorkGraph(this.gradle, workPlan.plan);
        });
    }

    @Override
    public ExecutionResult<Void> executeTasks(BuildWorkPlan plan) {
        DefaultBuildWorkPlan workPlan = this.unpack(plan);
        if (workPlan.empty) {
            return ExecutionResult.succeeded();
        }
        return this.buildState.tryTransition(State.ReadyToRun, State.Configure, () -> {
            List finalizations = workPlan.finalizations;
            if (!finalizations.isEmpty()) {
                EntryTaskSelectorContext context = new EntryTaskSelectorContext();
                for (BiConsumer finalization : finalizations) {
                    finalization.accept(context, workPlan.finalizedPlan.getContents());
                }
                workPlan.finalizations.clear();
            }
            return this.workExecutor.execute(this.gradle, workPlan.finalizedPlan);
        });
    }

    private DefaultBuildWorkPlan unpack(BuildWorkPlan plan) {
        DefaultBuildWorkPlan workPlan = (DefaultBuildWorkPlan)plan;
        if (workPlan.owner != this) {
            throw new IllegalArgumentException("Unexpected plan owner.");
        }
        return workPlan;
    }

    @Override
    public <T> T withToolingModels(boolean inResilientContext, Function<? super BuildToolingModelController, T> action) {
        return action.apply(this.toolingModelControllerFactory.createController(this.targetBuild(), this, inResilientContext));
    }

    private BuildState targetBuild() {
        return this.gradle.getOwner();
    }

    @Override
    public ExecutionResult<Void> finishBuild(@Nullable Throwable failure) {
        return this.buildState.transition((List<State>)CONFIGURATION_STATES, State.BuildFinishHooks, stageFailures -> {
            Throwable reportableFailure = failure;
            if (reportableFailure == null && !stageFailures.getFailures().isEmpty()) {
                reportableFailure = this.exceptionAnalyser.transform(stageFailures.getFailures());
            }
            BuildResult buildResult = new BuildResult(this.hasTasks ? "Build" : "Configure", (Gradle)this.gradle, reportableFailure);
            return ExecutionResult.maybeFailing(() -> this.buildListener.buildFinished(buildResult));
        });
    }

    @Override
    public void addListener(Object listener) {
        this.getGradle().addListener(listener);
    }

    private static enum State implements StateTransitionController.State
    {
        Configure,
        TaskSchedule,
        ReadyToRun,
        BuildFinishHooks,
        ReadyToReset,
        Finished;

    }

    private static class DefaultBuildWorkPlan
    implements BuildWorkPlan {
        private final DefaultBuildLifecycleController owner;
        private final ExecutionPlan plan;
        private final List<Consumer<LocalTaskNode>> handlers = new ArrayList<Consumer<LocalTaskNode>>();
        private final List<BiConsumer<EntryTaskSelector.Context, QueryableExecutionPlan>> finalizations = new ArrayList<BiConsumer<EntryTaskSelector.Context, QueryableExecutionPlan>>();
        private FinalizedExecutionPlan finalizedPlan;
        private boolean empty = true;

        public DefaultBuildWorkPlan(DefaultBuildLifecycleController owner, ExecutionPlan plan) {
            this.owner = owner;
            this.plan = plan;
        }

        public void stop() {
            this.plan.close();
        }

        @Override
        public void addFilter(Spec<Task> filter) {
            this.plan.addFilter(filter);
        }

        @Override
        public void addFinalization(BiConsumer<EntryTaskSelector.Context, QueryableExecutionPlan> finalization) {
            this.finalizations.add(finalization);
        }

        @Override
        public void onComplete(Consumer<LocalTaskNode> handler) {
            this.handlers.add(handler);
        }
    }

    @NullMarked
    private class EntryTaskSelectorContext
    implements EntryTaskSelector.Context {
        private EntryTaskSelectorContext() {
        }

        @Override
        public TaskSelection getSelection(String taskPath) {
            return this.selectionOf(Path.path((String)taskPath));
        }

        private TaskSelection selectionOf(Path taskPath) {
            Path taskProjectPath = taskPath.getParent();
            assert (taskProjectPath != null);
            ProjectInternal taskProject = this.resolveProject(taskProjectPath);
            if (taskProject != null) {
                String taskName = taskPath.getName();
                return new TaskSelection(taskProject.getPath(), taskName, tasks -> tasks.add(taskProject.getTasks().getByName(taskName)));
            }
            return new TaskSelection(null, null, tasks -> {});
        }

        @Override
        public GradleInternal getGradle() {
            return DefaultBuildLifecycleController.this.gradle;
        }

        private @Nullable ProjectInternal resolveProject(Path path) {
            assert (path.isAbsolute());
            Pair<Path, BuildState> includedBuildPrefix = this.resolveIncludedBuildPrefixOf(path);
            if (includedBuildPrefix != null) {
                Path includedBuildPath = (Path)includedBuildPrefix.left;
                BuildState includedBuild = (BuildState)includedBuildPrefix.right;
                Path projectPath = path.removeFirstSegments(includedBuildPath.segmentCount());
                return this.findProjectOf(includedBuild, projectPath);
            }
            return this.findProjectOf(DefaultBuildLifecycleController.this.targetBuild(), path);
        }

        private @Nullable Pair<Path, BuildState> resolveIncludedBuildPrefixOf(Path path) {
            Path candidatePath;
            BuildState existingBuild;
            Path resolvedPath = null;
            BuildState resolvedBuild = null;
            for (int prefixLength = 1; prefixLength <= path.segmentCount() && (existingBuild = this.findBuild(candidatePath = path.takeFirstSegments(prefixLength))) != null; ++prefixLength) {
                resolvedPath = candidatePath;
                resolvedBuild = existingBuild;
            }
            return resolvedPath != null ? Pair.of(resolvedPath, resolvedBuild) : null;
        }

        private @Nullable ProjectInternal findProjectOf(BuildState build, Path projectPath) {
            ProjectState project = build.getProjects().findProject(projectPath);
            return project != null ? project.getMutableModel() : null;
        }

        private @Nullable BuildState findBuild(Path buildPath) {
            return this.getBuildStateRegistry().findBuild(new DefaultBuildIdentifier(buildPath));
        }

        private BuildStateRegistry getBuildStateRegistry() {
            return (BuildStateRegistry)DefaultBuildLifecycleController.this.gradle.getServices().get(BuildStateRegistry.class);
        }
    }

    private class DefaultWorkGraphBuilder
    implements BuildLifecycleController.WorkGraphBuilder {
        private final ExecutionPlan plan;

        public DefaultWorkGraphBuilder(ExecutionPlan plan) {
            this.plan = plan;
        }

        @Override
        public void addRequestedTasks(@Nullable EntryTaskSelector selector) {
            DefaultBuildLifecycleController.this.modelController.scheduleRequestedTasks(selector, this.plan);
        }

        @Override
        public void addEntryTasks(List<? extends Task> tasks) {
            for (Task task : tasks) {
                this.plan.addEntryTask(task);
            }
        }

        @Override
        public void setScheduledWork(ScheduledWork work) {
            this.plan.setScheduledWork(work);
        }
    }
}

