/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.util.internal.ConfigureUtil;

public class ConfigureByMapAction<T>
implements Action<T> {
    private final Map<?, ?> properties;
    private final Collection<?> mandatoryProperties;

    public ConfigureByMapAction(Map<?, ?> properties) {
        this(properties, Collections.emptySet());
    }

    public ConfigureByMapAction(Map<?, ?> properties, Collection<?> mandatoryProperties) {
        this.properties = properties;
        this.mandatoryProperties = mandatoryProperties;
    }

    public void execute(T thing) {
        ConfigureUtil.configureByMap(this.properties, thing, this.mandatoryProperties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigureByMapAction that = (ConfigureByMapAction)o;
        return this.mandatoryProperties.equals(that.mandatoryProperties) && this.properties.equals(that.properties);
    }

    public int hashCode() {
        return 31 * this.properties.hashCode() + this.mandatoryProperties.hashCode();
    }
}

