/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.testng;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.gradle.api.GradleException;
import org.gradle.api.internal.tasks.testing.ClassTestDefinition;
import org.gradle.api.internal.tasks.testing.RequiresTestFrameworkTestDefinitionProcessor;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.testng.TestNGSpec;
import org.gradle.api.internal.tasks.testing.testng.TestNGTestRunner;
import org.gradle.internal.actor.Actor;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.time.Clock;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class TestNGTestDefinitionProcessor
implements RequiresTestFrameworkTestDefinitionProcessor<ClassTestDefinition> {
    private final List<Class<?>> testClasses = new ArrayList();
    private final File testReportDir;
    private final TestNGSpec spec;
    private final List<File> suiteFiles;
    private final IdGenerator<?> idGenerator;
    private final Clock clock;
    private final ActorFactory actorFactory;
    private @Nullable ClassLoader applicationClassLoader;
    private @Nullable Actor resultProcessorActor;
    private @Nullable TestResultProcessor resultProcessor;
    private boolean startedProcessing;

    public TestNGTestDefinitionProcessor(File testReportDir, TestNGSpec spec, List<File> suiteFiles, IdGenerator<?> idGenerator, Clock clock, ActorFactory actorFactory) {
        this.testReportDir = testReportDir;
        this.spec = spec;
        this.suiteFiles = suiteFiles;
        this.idGenerator = idGenerator;
        this.clock = clock;
        this.actorFactory = actorFactory;
    }

    public void assertTestFrameworkAvailable() {
        try {
            Class.forName("org.testng.TestNG");
        }
        catch (ClassNotFoundException e) {
            throw new RequiresTestFrameworkTestDefinitionProcessor.TestFrameworkNotAvailableException("Failed to load TestNG.  Please ensure that the TestNG library is available on the test's runtime classpath.");
        }
    }

    public void startProcessing(TestResultProcessor resultProcessor) {
        this.assertTestFrameworkAvailable();
        this.resultProcessorActor = this.actorFactory.createBlockingActor((Object)resultProcessor);
        this.resultProcessor = (TestResultProcessor)this.resultProcessorActor.getProxy(TestResultProcessor.class);
        this.applicationClassLoader = Thread.currentThread().getContextClassLoader();
        if (this.spec.isDryRun()) {
            System.setProperty("testng.mode.dryrun", "true");
        }
        this.startedProcessing = true;
    }

    public void processTestDefinition(ClassTestDefinition testDefinition) {
        if (this.startedProcessing) {
            try {
                this.testClasses.add(Objects.requireNonNull(this.applicationClassLoader).loadClass(testDefinition.getTestClassName()));
            }
            catch (Throwable e) {
                throw new GradleException(String.format("Could not load %s.", testDefinition.getDisplayName()), e);
            }
        }
    }

    public void stop() {
        if (this.startedProcessing) {
            try {
                new TestNGTestRunner(this.testReportDir, this.suiteFiles, this.idGenerator, this.clock, this.resultProcessor, this.applicationClassLoader, this.spec, this.testClasses).runTests();
            }
            finally {
                Actor actor = this.resultProcessorActor;
                if (actor != null) {
                    actor.stop();
                }
            }
        }
    }

    public void stopNow() {
        throw new UnsupportedOperationException("stopNow() should not be invoked on remote worker TestDefinitionProcessor");
    }
}

