/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report.generic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.gradle.api.internal.tasks.testing.results.serializable.OutputEntry;
import org.gradle.api.internal.tasks.testing.results.serializable.OutputTrackedResult;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResult;
import org.gradle.api.tasks.testing.TestMetadataEvent;
import org.jspecify.annotations.Nullable;

public final class PerRootInfo {
    private final SerializableTestResult result;
    private final long id;
    private final @Nullable OutputEntry outputEntry;
    private final ImmutableList<String> children;
    private final int totalLeafCount;
    private final int failedLeafCount;
    private final int skippedLeafCount;

    private PerRootInfo(OutputTrackedResult outputTrackedResult, ImmutableList<String> children, int totalLeafCount, int failedLeafCount, int skippedLeafCount) {
        this.result = outputTrackedResult.getInnerResult();
        this.id = outputTrackedResult.getId();
        this.outputEntry = outputTrackedResult.getOutputEntry().hasOutput() ? outputTrackedResult.getOutputEntry() : null;
        this.children = children;
        this.totalLeafCount = totalLeafCount;
        this.failedLeafCount = failedLeafCount;
        this.skippedLeafCount = skippedLeafCount;
    }

    public SerializableTestResult getResult() {
        return this.result;
    }

    public long getId() {
        return this.id;
    }

    public @Nullable OutputEntry getOutputEntry() {
        return this.outputEntry;
    }

    public ImmutableList<String> getChildren() {
        return this.children;
    }

    public int getTotalLeafCount() {
        return this.totalLeafCount;
    }

    public int getFailedLeafCount() {
        return this.failedLeafCount;
    }

    public int getSkippedLeafCount() {
        return this.skippedLeafCount;
    }

    public List<TestMetadataEvent> getMetadatas() {
        return this.result.getMetadatas();
    }

    public static final class Builder {
        private OutputTrackedResult outputTrackedResult;
        private final List<String> children;
        private final BitSet childIsLeaf;
        private int totalLeafCount;
        private int failedLeafCount;
        private int skippedLeafCount;

        public Builder(OutputTrackedResult result, List<String> childNames, BitSet childIsLeaf, int totalLeafCount, int failedLeafCount, int skippedLeafCount) {
            this.outputTrackedResult = result;
            this.children = new ArrayList<String>(childNames);
            this.childIsLeaf = childIsLeaf;
            this.totalLeafCount = totalLeafCount;
            this.failedLeafCount = failedLeafCount;
            this.skippedLeafCount = skippedLeafCount;
        }

        public String getName() {
            return this.outputTrackedResult.getInnerResult().getName();
        }

        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        public int getTotalLeafCount() {
            return this.totalLeafCount;
        }

        public int getFailedLeafCount() {
            return this.failedLeafCount;
        }

        public int getSkippedLeafCount() {
            return this.skippedLeafCount;
        }

        public void merge(Builder otherBuilder) {
            ImmutableSet knownChildren = ImmutableSet.copyOf(this.children);
            List<String> strings = otherBuilder.children;
            for (int i = 0; i < strings.size(); ++i) {
                String newChild = strings.get(i);
                boolean newChildIsLeaf = otherBuilder.childIsLeaf.get(i);
                if (!newChildIsLeaf && knownChildren.contains(newChild) && this.isExistingNonLeafChild(newChild)) continue;
                this.children.add(newChild);
                if (!newChildIsLeaf) continue;
                this.childIsLeaf.set(this.children.size() - 1);
            }
            this.totalLeafCount += otherBuilder.totalLeafCount;
            this.failedLeafCount += otherBuilder.failedLeafCount;
            this.skippedLeafCount += otherBuilder.skippedLeafCount;
            SerializableTestResult otherResult = otherBuilder.outputTrackedResult.getInnerResult();
            SerializableTestResult mergedResult = this.outputTrackedResult.getInnerResult().merge(otherResult);
            this.outputTrackedResult = this.outputTrackedResult.withInnerResult(mergedResult);
        }

        private boolean isExistingNonLeafChild(String child) {
            boolean anyNonLeaf = false;
            for (int j = 0; j < this.children.size(); ++j) {
                if (!this.children.get(j).equals(child) || this.childIsLeaf.get(j)) continue;
                anyNonLeaf = true;
                break;
            }
            return anyNonLeaf;
        }

        public PerRootInfo build() {
            return new PerRootInfo(this.outputTrackedResult, ImmutableList.copyOf(this.children), this.totalLeafCount, this.failedLeafCount, this.skippedLeafCount);
        }
    }
}

