/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.components.cipher;

import java.security.Provider;
import java.security.Security;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.sisu.Typed;
import org.sonatype.plexus.components.cipher.PBECipher;
import org.sonatype.plexus.components.cipher.PlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;

@Singleton
@Named(value="default")
@Typed(value={PlexusCipher.class})
public class DefaultPlexusCipher
implements PlexusCipher {
    private static final Pattern ENCRYPTED_STRING_PATTERN = Pattern.compile(".*?[^\\\\]?\\{(.*?[^\\\\])\\}.*");
    private final PBECipher _cipher = new PBECipher();

    @Override
    public String encrypt(String str, String passPhrase) throws PlexusCipherException {
        if (str == null || str.length() < 1) {
            return str;
        }
        return this._cipher.encrypt64(str, passPhrase);
    }

    @Override
    public String encryptAndDecorate(String str, String passPhrase) throws PlexusCipherException {
        return this.decorate(this.encrypt(str, passPhrase));
    }

    @Override
    public String decrypt(String str, String passPhrase) throws PlexusCipherException {
        if (str == null || str.length() < 1) {
            return str;
        }
        return this._cipher.decrypt64(str, passPhrase);
    }

    @Override
    public String decryptDecorated(String str, String passPhrase) throws PlexusCipherException {
        if (str == null || str.length() < 1) {
            return str;
        }
        if (this.isEncryptedString(str)) {
            return this.decrypt(this.unDecorate(str), passPhrase);
        }
        return this.decrypt(str, passPhrase);
    }

    @Override
    public boolean isEncryptedString(String str) {
        if (str == null || str.length() < 1) {
            return false;
        }
        Matcher matcher = ENCRYPTED_STRING_PATTERN.matcher(str);
        return matcher.matches() || matcher.find();
    }

    @Override
    public String unDecorate(String str) throws PlexusCipherException {
        Matcher matcher = ENCRYPTED_STRING_PATTERN.matcher(str);
        if (matcher.matches() || matcher.find()) {
            return matcher.group(1);
        }
        throw new PlexusCipherException("default.plexus.cipher.badEncryptedPassword");
    }

    @Override
    public String decorate(String str) {
        return '{' + (str == null ? "" : str) + '}';
    }

    public static String[] getServiceTypes() {
        Provider[] providers;
        HashSet<String> result = new HashSet<String>();
        for (Provider provider : providers = Security.getProviders()) {
            Set<Object> keys = provider.keySet();
            for (Object o : keys) {
                String key = (String)o;
                if ((key = key.split(" ")[0]).startsWith("Alg.Alias.")) {
                    key = key.substring(10);
                }
                int ix = key.indexOf(46);
                result.add(key.substring(0, ix));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] getCryptoImpls(String serviceType) {
        Provider[] providers;
        HashSet<String> result = new HashSet<String>();
        for (Provider provider : providers = Security.getProviders()) {
            Set<Object> keys = provider.keySet();
            for (Object o : keys) {
                String key = (String)o;
                if ((key = key.split(" ")[0]).startsWith(serviceType + ".")) {
                    result.add(key.substring(serviceType.length() + 1));
                    continue;
                }
                if (!key.startsWith("Alg.Alias." + serviceType + ".")) continue;
                result.add(key.substring(serviceType.length() + 11));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static void main(String[] args) {
        String[] serviceTypes = DefaultPlexusCipher.getServiceTypes();
        if (serviceTypes != null) {
            for (String serviceType : serviceTypes) {
                String[] serviceProviders = DefaultPlexusCipher.getCryptoImpls(serviceType);
                if (serviceProviders != null) {
                    System.out.println(serviceType + ": provider list");
                    for (String provider : serviceProviders) {
                        System.out.println("        " + provider);
                    }
                    continue;
                }
                System.out.println(serviceType + ": does not have any providers in this environment");
            }
        }
    }
}

