/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.tasks.TaskDependencyUtil;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.AbstractClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.AbstractLibrary;
import org.gradle.plugins.ide.eclipse.model.AccessRule;
import org.gradle.plugins.ide.eclipse.model.BuildCommand;
import org.gradle.plugins.ide.eclipse.model.Classpath;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.Container;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseJdt;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.EclipseProject;
import org.gradle.plugins.ide.eclipse.model.Library;
import org.gradle.plugins.ide.eclipse.model.Output;
import org.gradle.plugins.ide.eclipse.model.ProjectDependency;
import org.gradle.plugins.ide.eclipse.model.SourceFolder;
import org.gradle.plugins.ide.eclipse.model.UnresolvedLibrary;
import org.gradle.plugins.ide.internal.configurer.EclipseModelAwareUniqueProjectNameProvider;
import org.gradle.plugins.ide.internal.tooling.GradleProjectBuilderInternal;
import org.gradle.plugins.ide.internal.tooling.TasksFactory;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultAccessRule;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultClasspathAttribute;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseBuildCommand;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseClasspathContainer;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseExternalDependency;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseJavaSourceSettings;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseLinkedResource;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseOutputLocation;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseProject;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseProjectDependency;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseProjectNature;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseSourceDirectory;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseTask;
import org.gradle.plugins.ide.internal.tooling.java.DefaultInstalledJdk;
import org.gradle.plugins.ide.internal.tooling.model.DefaultGradleProject;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.eclipse.EclipseRuntime;
import org.gradle.tooling.model.eclipse.EclipseWorkspace;
import org.gradle.tooling.model.eclipse.EclipseWorkspaceProject;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.GUtil;

public class EclipseModelBuilder
implements ParameterizedToolingModelBuilder<EclipseRuntime> {
    private final GradleProjectBuilderInternal gradleProjectBuilder;
    private final EclipseModelAwareUniqueProjectNameProvider uniqueProjectNameProvider;
    private boolean projectDependenciesOnly;
    private DefaultEclipseProject result;
    private List<DefaultEclipseProject> eclipseProjects;
    private TasksFactory tasksFactory;
    private DefaultGradleProject rootGradleProject;
    private ProjectIdentity currentProjectId;
    private EclipseRuntime eclipseRuntime;
    private Map<String, Boolean> projectOpenStatus = new HashMap<String, Boolean>();

    @VisibleForTesting
    public EclipseModelBuilder(GradleProjectBuilderInternal gradleProjectBuilder, EclipseModelAwareUniqueProjectNameProvider uniqueProjectNameProvider) {
        this.gradleProjectBuilder = gradleProjectBuilder;
        this.uniqueProjectNameProvider = uniqueProjectNameProvider;
    }

    public EclipseModelBuilder(GradleProjectBuilderInternal gradleProjectBuilder, ProjectStateRegistry projectStateRegistry) {
        this(gradleProjectBuilder, new EclipseModelAwareUniqueProjectNameProvider(projectStateRegistry));
    }

    public boolean canBuild(String modelName) {
        return modelName.equals("org.gradle.tooling.model.eclipse.EclipseProject") || modelName.equals("org.gradle.tooling.model.eclipse.HierarchicalEclipseProject");
    }

    public Class<EclipseRuntime> getParameterType() {
        return EclipseRuntime.class;
    }

    public Object buildAll(String modelName, EclipseRuntime eclipseRuntime, Project project) {
        this.eclipseRuntime = eclipseRuntime;
        List projects = eclipseRuntime.getWorkspace().getProjects();
        HashSet projectsInBuild = new HashSet(projects);
        projectsInBuild.removeAll(this.gatherExternalProjects((ProjectInternal)project.getRootProject(), projects));
        this.projectOpenStatus = projectsInBuild.stream().collect(Collectors.toMap(EclipseWorkspaceProject::getName, EclipseModelBuilder::isProjectOpen, (a, b) -> a != false || b != false));
        return this.buildAll(modelName, project);
    }

    public static boolean isProjectOpen(EclipseWorkspaceProject project) {
        try {
            return project.isOpen();
        }
        catch (UnsupportedMethodException e) {
            return true;
        }
    }

    public DefaultEclipseProject buildAll(String modelName, Project project) {
        boolean includeTasks = modelName.equals("org.gradle.tooling.model.eclipse.EclipseProject");
        this.tasksFactory = new TasksFactory(includeTasks);
        this.projectDependenciesOnly = modelName.equals("org.gradle.tooling.model.eclipse.HierarchicalEclipseProject");
        this.currentProjectId = ((ProjectInternal)project).getProjectIdentity();
        this.eclipseProjects = new ArrayList<DefaultEclipseProject>();
        ProjectInternal root = (ProjectInternal)project.getRootProject();
        ProjectState rootProjectState = root.getOwner();
        this.rootGradleProject = this.gradleProjectBuilder.buildForRoot(project);
        this.tasksFactory.collectTasks((Project)root);
        this.applyEclipsePlugin(root, new ArrayList<GradleInternal>());
        this.deduplicateProjectNames(root);
        this.buildHierarchy(rootProjectState);
        this.populate(rootProjectState);
        return this.result;
    }

    private void deduplicateProjectNames(ProjectInternal root) {
        this.uniqueProjectNameProvider.setReservedProjectNames(this.calculateReservedProjectNames(root, this.eclipseRuntime));
        for (Project project : root.getAllprojects()) {
            EclipseModel eclipseModel = (EclipseModel)project.getExtensions().findByType(EclipseModel.class);
            if (eclipseModel == null) continue;
            eclipseModel.getProject().setName(this.uniqueProjectNameProvider.getUniqueName(((ProjectInternal)project).getProjectIdentity()));
        }
    }

    private void applyEclipsePlugin(ProjectInternal root, List<GradleInternal> alreadyProcessed) {
        Set allProjects = root.getAllprojects();
        for (Project p : allProjects) {
            p.getPluginManager().apply(EclipsePlugin.class);
        }
        for (IncludedBuildInternal reference : root.getGradle().includedBuilds()) {
            BuildState target = reference.getTarget();
            if (!(target instanceof IncludedBuildState)) continue;
            target.ensureProjectsConfigured();
            GradleInternal build = target.getMutableModel();
            if (alreadyProcessed.contains(build)) continue;
            alreadyProcessed.add(build);
            this.applyEclipsePlugin(build.getRootProject(), alreadyProcessed);
        }
    }

    private DefaultEclipseProject buildHierarchy(ProjectState projectState) {
        ArrayList<DefaultEclipseProject> children = new ArrayList<DefaultEclipseProject>();
        for (ProjectState child : projectState.getChildProjects()) {
            children.add(this.buildHierarchy(child));
        }
        EclipseModel eclipseModel = (EclipseModel)projectState.getMutableModel().getExtensions().getByType(EclipseModel.class);
        EclipseProject internalProject = eclipseModel.getProject();
        String name = internalProject.getName();
        String path = projectState.getIdentity().getProjectPath().asString();
        String description = (String)GUtil.elvis((Object)internalProject.getComment(), null);
        File projectDir = projectState.getProjectDir();
        DefaultEclipseProject eclipseProject = new DefaultEclipseProject(name, path, description, projectDir, children).setGradleProject(this.rootGradleProject.findByPath(path));
        for (DefaultEclipseProject child : children) {
            child.setParent(eclipseProject);
        }
        this.addProject(projectState, eclipseProject);
        return eclipseProject;
    }

    private void addProject(ProjectState project, DefaultEclipseProject eclipseProject) {
        if (project.getIdentity().equals((Object)this.currentProjectId)) {
            this.result = eclipseProject;
        }
        this.eclipseProjects.add(eclipseProject);
    }

    private void populate(ProjectState p) {
        p.applyToMutableState(project -> {
            EclipseModel eclipseModel = (EclipseModel)project.getExtensions().getByType(EclipseModel.class);
            boolean projectDependenciesOnly = this.projectDependenciesOnly;
            ClasspathElements classpathElements = EclipseModelBuilder.gatherClasspathElements(this.projectOpenStatus, eclipseModel.getClasspath(), projectDependenciesOnly);
            DefaultEclipseProject eclipseProject = this.findEclipseProject((Project)project);
            eclipseProject.setClasspath(classpathElements.getExternalDependencies());
            eclipseProject.setProjectDependencies(classpathElements.getProjectDependencies());
            eclipseProject.setSourceDirectories(classpathElements.getSourceDirectories());
            eclipseProject.setClasspathContainers(classpathElements.getClasspathContainers());
            eclipseProject.setOutputLocation(classpathElements.getEclipseOutputLocation() != null ? classpathElements.getEclipseOutputLocation() : new DefaultEclipseOutputLocation("bin"));
            eclipseProject.setAutoBuildTasks(!TaskDependencyUtil.getDependenciesForInternalUse((TaskDependency)eclipseModel.getAutoBuildTasks(), null).isEmpty());
            org.gradle.plugins.ide.eclipse.model.Project xmlProject = new org.gradle.plugins.ide.eclipse.model.Project(new XmlTransformer());
            XmlFileContentMerger projectFile = eclipseModel.getProject().getFile();
            if (projectFile == null) {
                xmlProject.configure(eclipseModel.getProject());
            } else {
                eclipseModel.getProject().mergeXmlProject(xmlProject);
            }
            EclipseModelBuilder.populateEclipseProjectTasks(eclipseProject, this.tasksFactory.getTasks((Project)project));
            EclipseModelBuilder.populateEclipseProject(eclipseProject, xmlProject);
            EclipseModelBuilder.populateEclipseProjectJdt(eclipseProject, eclipseModel.getJdt());
        });
        for (ProjectState childProject : p.getChildProjects()) {
            this.populate(childProject);
        }
    }

    public static ClasspathElements gatherClasspathElements(Map<String, Boolean> projectOpenStatus, EclipseClasspath eclipseClasspath, boolean projectDependenciesOnly) {
        List classpathEntries;
        ClasspathElements classpathElements = new ClasspathElements();
        eclipseClasspath.setProjectDependenciesOnly(projectDependenciesOnly);
        if (eclipseClasspath.getFile() == null) {
            classpathEntries = eclipseClasspath.resolveDependencies();
        } else {
            Classpath classpath = new Classpath(eclipseClasspath.getFileReferenceFactory());
            eclipseClasspath.mergeXmlClasspath(classpath);
            classpathEntries = classpath.getEntries();
        }
        HashMap<String, DefaultEclipseProjectDependency> projectDependencyMap = new HashMap<String, DefaultEclipseProjectDependency>();
        for (ClasspathEntry entry : classpathEntries) {
            String path;
            if (entry instanceof Library) {
                DefaultEclipseExternalDependency dependency;
                File javadoc;
                AbstractLibrary library = (AbstractLibrary)entry;
                File file = library.getLibrary().getFile();
                File source = library.getSourcePath() == null ? null : library.getSourcePath().getFile();
                File file2 = javadoc = library.getJavadocPath() == null ? null : library.getJavadocPath().getFile();
                if (entry instanceof UnresolvedLibrary) {
                    UnresolvedLibrary unresolvedLibrary = (UnresolvedLibrary)entry;
                    dependency = DefaultEclipseExternalDependency.createUnresolved((File)file, (File)javadoc, (File)source, (ModuleVersionIdentifier)library.getModuleVersion(), (boolean)library.isExported(), EclipseModelBuilder.createAttributes((AbstractClasspathEntry)library), EclipseModelBuilder.createAccessRules((AbstractClasspathEntry)library), (String)unresolvedLibrary.getAttemptedSelector().getDisplayName());
                } else {
                    dependency = DefaultEclipseExternalDependency.createResolved((File)file, (File)javadoc, (File)source, (ModuleVersionIdentifier)library.getModuleVersion(), (boolean)library.isExported(), EclipseModelBuilder.createAttributes((AbstractClasspathEntry)library), EclipseModelBuilder.createAccessRules((AbstractClasspathEntry)library));
                }
                classpathElements.getExternalDependencies().add(dependency);
                continue;
            }
            if (entry instanceof ProjectDependency) {
                ProjectDependency projectDependency = (ProjectDependency)entry;
                path = StringUtils.removeStart((String)projectDependency.getPath(), (String)"/");
                boolean isProjectOpen = projectOpenStatus.getOrDefault(path, true);
                if (!isProjectOpen) {
                    File source = projectDependency.getPublicationSourcePath() == null ? null : projectDependency.getPublicationSourcePath().getFile();
                    File javadoc = projectDependency.getPublicationJavadocPath() == null ? null : projectDependency.getPublicationJavadocPath().getFile();
                    classpathElements.getExternalDependencies().add(DefaultEclipseExternalDependency.createResolved((File)projectDependency.getPublication().getFile(), (File)javadoc, (File)source, null, (boolean)projectDependency.isExported(), EclipseModelBuilder.createAttributes((AbstractClasspathEntry)projectDependency), EclipseModelBuilder.createAccessRules((AbstractClasspathEntry)projectDependency)));
                    classpathElements.getBuildDependencies().add(projectDependency.getBuildDependencies());
                    continue;
                }
                DefaultEclipseProjectDependency dependency = new DefaultEclipseProjectDependency(path, projectDependency.isExported(), EclipseModelBuilder.createAttributes((AbstractClasspathEntry)projectDependency), EclipseModelBuilder.createAccessRules((AbstractClasspathEntry)projectDependency));
                projectDependencyMap.merge(path, dependency, (oldDependency, newDependency) -> !EclipseModelBuilder.hasTestSourcesAttribute(oldDependency) && EclipseModelBuilder.hasTestSourcesAttribute(newDependency) ? oldDependency : newDependency);
                continue;
            }
            if (entry instanceof SourceFolder) {
                SourceFolder sourceFolder = (SourceFolder)entry;
                path = sourceFolder.getPath();
                List excludes = sourceFolder.getExcludes();
                List includes = sourceFolder.getIncludes();
                String output = sourceFolder.getOutput();
                classpathElements.getSourceDirectories().add(new DefaultEclipseSourceDirectory(path, sourceFolder.getDir(), excludes, includes, output, EclipseModelBuilder.createAttributes((AbstractClasspathEntry)sourceFolder), EclipseModelBuilder.createAccessRules((AbstractClasspathEntry)sourceFolder)));
                continue;
            }
            if (entry instanceof Container) {
                Container container = (Container)entry;
                classpathElements.getClasspathContainers().add(new DefaultEclipseClasspathContainer(container.getPath(), container.isExported(), EclipseModelBuilder.createAttributes((AbstractClasspathEntry)container), EclipseModelBuilder.createAccessRules((AbstractClasspathEntry)container)));
                continue;
            }
            if (!(entry instanceof Output)) continue;
            classpathElements.setEclipseOutputLocation(new DefaultEclipseOutputLocation(((Output)entry).getPath()));
        }
        classpathElements.getProjectDependencies().addAll(projectDependencyMap.values());
        return classpathElements;
    }

    private static void populateEclipseProjectTasks(DefaultEclipseProject eclipseProject, Iterable<Task> projectTasks) {
        ArrayList<DefaultEclipseTask> tasks = new ArrayList<DefaultEclipseTask>();
        for (Task t : projectTasks) {
            tasks.add(new DefaultEclipseTask(eclipseProject, t.getPath(), t.getName(), t.getDescription()));
        }
        eclipseProject.setTasks(tasks);
    }

    private static void populateEclipseProject(DefaultEclipseProject eclipseProject, org.gradle.plugins.ide.eclipse.model.Project xmlProject) {
        LinkedList<DefaultEclipseLinkedResource> linkedResources = new LinkedList<DefaultEclipseLinkedResource>();
        for (Object r : xmlProject.getLinkedResources()) {
            linkedResources.add(new DefaultEclipseLinkedResource(r.getName(), r.getType(), r.getLocation(), r.getLocationUri()));
        }
        eclipseProject.setLinkedResources(linkedResources);
        ArrayList<DefaultEclipseProjectNature> natures = new ArrayList<DefaultEclipseProjectNature>();
        for (String n : xmlProject.getNatures()) {
            natures.add(new DefaultEclipseProjectNature(n));
        }
        eclipseProject.setProjectNatures(natures);
        ArrayList<DefaultEclipseBuildCommand> buildCommands = new ArrayList<DefaultEclipseBuildCommand>();
        for (BuildCommand b : xmlProject.getBuildCommands()) {
            LinkedHashMap<String, String> arguments = new LinkedHashMap<String, String>();
            for (Map.Entry entry : b.getArguments().entrySet()) {
                arguments.put(EclipseModelBuilder.convertGString((CharSequence)entry.getKey()), EclipseModelBuilder.convertGString((CharSequence)entry.getValue()));
            }
            buildCommands.add(new DefaultEclipseBuildCommand(b.getName(), arguments));
        }
        eclipseProject.setBuildCommands(buildCommands);
    }

    private static void populateEclipseProjectJdt(DefaultEclipseProject eclipseProject, EclipseJdt jdt) {
        if (jdt != null) {
            eclipseProject.setJavaSourceSettings(new DefaultEclipseJavaSourceSettings().setSourceLanguageLevel(jdt.getSourceCompatibility()).setTargetBytecodeVersion(jdt.getTargetCompatibility()).setJdk(DefaultInstalledJdk.current()));
        }
    }

    private DefaultEclipseProject findEclipseProject(Project project) {
        return (DefaultEclipseProject)CollectionUtils.findFirst(this.eclipseProjects, element -> element.getGradleProject().getPath().equals(project.getPath()));
    }

    private static List<DefaultClasspathAttribute> createAttributes(AbstractClasspathEntry classpathEntry) {
        ArrayList<DefaultClasspathAttribute> result = new ArrayList<DefaultClasspathAttribute>();
        Map attributes = classpathEntry.getEntryAttributes();
        for (Map.Entry entry : attributes.entrySet()) {
            Object value = entry.getValue();
            result.add(new DefaultClasspathAttribute(EclipseModelBuilder.convertGString((CharSequence)entry.getKey()), value == null ? "" : value.toString()));
        }
        return result;
    }

    private static List<DefaultAccessRule> createAccessRules(AbstractClasspathEntry classpathEntry) {
        ArrayList<DefaultAccessRule> result = new ArrayList<DefaultAccessRule>();
        for (AccessRule accessRule : classpathEntry.getAccessRules()) {
            result.add(EclipseModelBuilder.createAccessRule(accessRule));
        }
        return result;
    }

    private static DefaultAccessRule createAccessRule(AccessRule accessRule) {
        int kindCode;
        String kind;
        switch (kind = accessRule.getKind()) {
            case "accessible": 
            case "0": {
                kindCode = 0;
                break;
            }
            case "nonaccessible": 
            case "1": {
                kindCode = 1;
                break;
            }
            case "discouraged": 
            case "2": {
                kindCode = 2;
                break;
            }
            default: {
                kindCode = 0;
            }
        }
        return new DefaultAccessRule(kindCode, accessRule.getPattern());
    }

    private List<Project> collectAllProjects(List<Project> all, GradleInternal gradle, Set<Gradle> allBuilds) {
        all.addAll(gradle.getRootProject().getAllprojects());
        for (IncludedBuildInternal reference : gradle.includedBuilds()) {
            BuildState target = reference.getTarget();
            if (!(target instanceof IncludedBuildState)) continue;
            target.ensureProjectsConfigured();
            GradleInternal build = target.getMutableModel();
            if (allBuilds.contains(build)) continue;
            allBuilds.add((Gradle)build);
            this.collectAllProjects(all, build, allBuilds);
        }
        return all;
    }

    private GradleInternal getRootBuild(GradleInternal gradle) {
        if (gradle.getParent() == null) {
            return gradle;
        }
        return gradle.getParent();
    }

    private List<String> calculateReservedProjectNames(ProjectInternal rootProject, EclipseRuntime parameter) {
        if (parameter == null) {
            return Collections.emptyList();
        }
        EclipseWorkspace workspace = parameter.getWorkspace();
        if (workspace == null) {
            return Collections.emptyList();
        }
        List projects = workspace.getProjects();
        if (projects == null) {
            return Collections.emptyList();
        }
        ArrayList<String> reservedProjectNames = new ArrayList<String>();
        List<EclipseWorkspaceProject> externalProjects = this.gatherExternalProjects(rootProject, projects);
        for (EclipseWorkspaceProject externalProject : externalProjects) {
            reservedProjectNames.add(externalProject.getName());
        }
        return reservedProjectNames;
    }

    private List<EclipseWorkspaceProject> gatherExternalProjects(ProjectInternal rootProject, List<EclipseWorkspaceProject> projects) {
        Set gradleProjectLocations = this.collectAllProjects(new ArrayList<Project>(), this.getRootBuild(rootProject.getGradle()), new HashSet<Gradle>()).stream().map(p -> p.getProjectDir().getAbsoluteFile()).collect(Collectors.toSet());
        ArrayList<EclipseWorkspaceProject> externalProjects = new ArrayList<EclipseWorkspaceProject>();
        for (EclipseWorkspaceProject project : projects) {
            if (project == null || project.getLocation() == null || project.getName() == null || project.getLocation() == null || gradleProjectLocations.contains(project.getLocation().getAbsoluteFile())) continue;
            externalProjects.add(project);
        }
        return externalProjects;
    }

    private static boolean hasTestSourcesAttribute(DefaultEclipseProjectDependency projectDependency) {
        return projectDependency.getClasspathAttributes().stream().anyMatch(attribute -> "test".equals(attribute.getName()) && "true".equals(attribute.getValue()));
    }

    private static String convertGString(CharSequence original) {
        return original.toString();
    }

    public static class ClasspathElements {
        private final List<DefaultEclipseExternalDependency> externalDependencies = new ArrayList<DefaultEclipseExternalDependency>();
        private final List<DefaultEclipseProjectDependency> projectDependencies = new ArrayList<DefaultEclipseProjectDependency>();
        private final List<DefaultEclipseSourceDirectory> sourceDirectories = new ArrayList<DefaultEclipseSourceDirectory>();
        private final List<DefaultEclipseClasspathContainer> classpathContainers = new ArrayList<DefaultEclipseClasspathContainer>();
        private final List<TaskDependency> buildDependencies = new ArrayList<TaskDependency>();
        private DefaultEclipseOutputLocation eclipseOutputLocation;

        public List<DefaultEclipseExternalDependency> getExternalDependencies() {
            return this.externalDependencies;
        }

        public List<DefaultEclipseProjectDependency> getProjectDependencies() {
            return this.projectDependencies;
        }

        public List<DefaultEclipseSourceDirectory> getSourceDirectories() {
            return this.sourceDirectories;
        }

        public List<DefaultEclipseClasspathContainer> getClasspathContainers() {
            return this.classpathContainers;
        }

        public List<TaskDependency> getBuildDependencies() {
            return this.buildDependencies;
        }

        public DefaultEclipseOutputLocation getEclipseOutputLocation() {
            return this.eclipseOutputLocation;
        }

        public void setEclipseOutputLocation(DefaultEclipseOutputLocation eclipseOutputLocation) {
            this.eclipseOutputLocation = eclipseOutputLocation;
        }
    }
}

