/*
 * Copyright 2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.nativeplatform.fixtures.app

class Swift6Test extends XCTestSourceFileElement {
    Swift6Test() {
        super("Swift6Test")
    }

    @Override
    List<XCTestCaseElement> getTestCases() {
        return [
            testCase("testDrinking",
            '''XCTAssertEqual(doDrinking(), "Drinking coffee and Drinking water")'''),
            testCase("testCodeWasCompiledWithSwift6Compiler",
                """#if swift(>=7.0)
                        XCTFail("Compilation unit compiled with Swift 7+ instead of Swift 6.x");
                    #elseif swift(>=6.0)
                        // Do nothing
                    #else
                        XCTFail("Compilation unit compiled with Swift 5- instead of Swift 6.x");
                    #endif
                """)
        ]
    }
}
