/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.health.memory;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.gradle.process.internal.health.memory.OsMemoryInfo;
import org.gradle.process.internal.health.memory.OsMemoryStatus;
import org.gradle.process.internal.health.memory.OsMemoryStatusSnapshot;

public class CGroupMemoryInfo
implements OsMemoryInfo {
    private static final String CG1_MEM_USAGE_FILE = "/sys/fs/cgroup/memory/memory.usage_in_bytes";
    private static final String CG1_MEM_TOTAL_FILE = "/sys/fs/cgroup/memory/memory.limit_in_bytes";
    private static final String CG2_MEM_USAGE_FILE = "/sys/fs/cgroup/memory.current";
    private static final String CG2_MEM_TOTAL_FILE = "/sys/fs/cgroup/memory.max";

    @Override
    public OsMemoryStatus getOsSnapshot() {
        File cg2Usage = new File(CG2_MEM_USAGE_FILE);
        File cg2Total = new File(CG2_MEM_TOTAL_FILE);
        if (cg2Usage.exists() && cg2Total.exists()) {
            return this.getOsSnapshotFromCgroup(CGroupMemoryInfo.readStringFromFile(cg2Usage), CGroupMemoryInfo.readStringFromFile(cg2Total));
        }
        return this.getOsSnapshotFromCgroup(CGroupMemoryInfo.readStringFromFile(new File(CG1_MEM_USAGE_FILE)), CGroupMemoryInfo.readStringFromFile(new File(CG1_MEM_TOTAL_FILE)));
    }

    private static String readStringFromFile(File file) {
        try {
            return Files.asCharSource((File)file, (Charset)Charset.defaultCharset()).readFirstLine();
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Unable to read system memory from " + file.getAbsoluteFile(), e);
        }
    }

    @VisibleForTesting
    OsMemoryStatusSnapshot getOsSnapshotFromCgroup(String memUsageString, String memTotalString) {
        long memAvailable;
        long memTotal;
        try {
            long memUsage = Long.parseLong(memUsageString);
            memTotal = Long.parseLong(memTotalString);
            memAvailable = Math.max(0L, memTotal - memUsage);
        }
        catch (NumberFormatException e) {
            throw new UnsupportedOperationException("Unable to read system memory", e);
        }
        return new OsMemoryStatusSnapshot(memTotal, memAvailable);
    }
}

