/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.testing;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.exceptions.MarkedVerificationException;
import org.gradle.api.internal.tasks.testing.DefaultTestTaskReports;
import org.gradle.api.internal.tasks.testing.FailFastTestListenerInternal;
import org.gradle.api.internal.tasks.testing.GroupTestEventReporterInternal;
import org.gradle.api.internal.tasks.testing.MultiTestReportGenerator;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestEventReporterFactoryInternal;
import org.gradle.api.internal.tasks.testing.TestExecuter;
import org.gradle.api.internal.tasks.testing.TestExecutionSpec;
import org.gradle.api.internal.tasks.testing.TestReportGenerator;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.junit.result.JUnitXmlResultOptions;
import org.gradle.api.internal.tasks.testing.junit.result.TestEventReporterAsListener;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.internal.tasks.testing.logging.DefaultTestLoggingContainer;
import org.gradle.api.internal.tasks.testing.logging.FullExceptionFormatter;
import org.gradle.api.internal.tasks.testing.logging.ShortExceptionFormatter;
import org.gradle.api.internal.tasks.testing.logging.TestCountLogger;
import org.gradle.api.internal.tasks.testing.logging.TestEventLogger;
import org.gradle.api.internal.tasks.testing.logging.TestExceptionFormatter;
import org.gradle.api.internal.tasks.testing.logging.TestWorkerProgressListener;
import org.gradle.api.internal.tasks.testing.report.TestReporter;
import org.gradle.api.internal.tasks.testing.report.generic.GenericHtmlTestReportGenerator;
import org.gradle.api.internal.tasks.testing.report.generic.JunitXmlTestReportGenerator;
import org.gradle.api.internal.tasks.testing.report.generic.TestTreeModelResultsProvider;
import org.gradle.api.internal.tasks.testing.results.StateTrackingTestResultProcessor;
import org.gradle.api.internal.tasks.testing.results.TestListenerAdapter;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.api.tasks.options.Option;
import org.gradle.api.tasks.testing.JUnitXmlReport;
import org.gradle.api.tasks.testing.TestEventReporterFactory;
import org.gradle.api.tasks.testing.TestFilter;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestOutputListener;
import org.gradle.api.tasks.testing.TestTaskReports;
import org.gradle.api.tasks.testing.logging.TestLogging;
import org.gradle.api.tasks.testing.logging.TestLoggingContainer;
import org.gradle.internal.Cast;
import org.gradle.internal.Describables;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.dispatch.MethodInvocation;
import org.gradle.internal.event.AnonymousListenerBroadcast;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.nativeintegration.network.HostnameLookup;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.listener.ClosureBackedMethodInvocationDispatch;
import org.gradle.util.internal.ClosureBackedAction;
import org.gradle.util.internal.ConfigureUtil;
import org.gradle.work.DisableCachingByDefault;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@DisableCachingByDefault(because="Abstract super-class, not to be instantiated directly")
public abstract class AbstractTestTask
extends ConventionTask
implements VerificationTask,
Reporting<TestTaskReports> {
    private final DefaultTestFilter filter;
    private final TestTaskReports reports;
    private final BroadcastSubscriptions<TestListener> testListenerSubscriptions;
    private final BroadcastSubscriptions<TestOutputListener> testOutputListenerSubscriptions;
    private final TestLoggingContainer testLogging;
    private TestReporter testReporter;
    private boolean ignoreFailures;
    private boolean failFast;

    public AbstractTestTask() {
        ObjectFactory objectFactory = this.getObjectFactory();
        this.testLogging = (TestLoggingContainer)objectFactory.newInstance(DefaultTestLoggingContainer.class, new Object[0]);
        this.testListenerSubscriptions = new BroadcastSubscriptions(TestListener.class);
        this.testOutputListenerSubscriptions = new BroadcastSubscriptions(TestOutputListener.class);
        this.reports = (TestTaskReports)this.getObjectFactory().newInstance(DefaultTestTaskReports.class, new Object[]{Describables.quoted((Object)"Task", (Object)this.getIdentityPath())});
        this.reports.getJunitXml().getRequired().set((Object)true);
        this.reports.getHtml().getRequired().set((Object)true);
        this.filter = (DefaultTestFilter)objectFactory.newInstance(DefaultTestFilter.class, new Object[0]);
        this.getFailOnNoDiscoveredTests().convention((Object)true);
    }

    @Inject
    protected abstract ProgressLoggerFactory getProgressLoggerFactory();

    @Inject
    protected abstract StyledTextOutputFactory getTextOutputFactory();

    @Inject
    protected abstract HostnameLookup getHostnameLookup();

    @Inject
    protected abstract BuildOperationRunner getBuildOperationRunner();

    @Inject
    protected abstract BuildOperationExecutor getBuildOperationExecutor();

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    @Inject
    protected abstract Instantiator getInstantiator();

    @Inject
    protected abstract ListenerManager getListenerManager();

    @Inject
    protected abstract FileSystemOperations getFileSystemOperations();

    @Inject
    protected abstract TestEventReporterFactory getTestEventReporterFactory();

    protected abstract TestExecuter<? extends TestExecutionSpec> createTestExecuter();

    protected abstract TestExecutionSpec createTestExecutionSpec();

    @Internal
    protected int getReportEntrySkipLevels() {
        return 0;
    }

    @Deprecated
    void setTestReporter(TestReporter testReporter) {
        this.testReporter = testReporter;
    }

    private LogLevel determineCurrentLogLevel() {
        for (LogLevel level : LogLevel.values()) {
            if (!this.getLogger().isEnabled(level)) continue;
            return level;
        }
        throw new AssertionError((Object)"could not determine current log level");
    }

    @OutputDirectory
    public abstract DirectoryProperty getBinaryResultsDirectory();

    public void addTestListener(TestListener listener) {
        this.testListenerSubscriptions.addListener(listener);
    }

    private void addDispatchAsTestListener(String methodName, Closure closure) {
        this.testListenerSubscriptions.addListener((Dispatch<MethodInvocation>)new ClosureBackedMethodInvocationDispatch(methodName, closure));
    }

    public void addTestOutputListener(TestOutputListener listener) {
        this.testOutputListenerSubscriptions.addListener(listener);
    }

    private void addDispatchAsTestOutputListener(String methodName, Closure closure) {
        this.testOutputListenerSubscriptions.addListener((Dispatch<MethodInvocation>)new ClosureBackedMethodInvocationDispatch(methodName, closure));
    }

    public void removeTestListener(TestListener listener) {
        this.testListenerSubscriptions.removeListener(listener);
    }

    public void removeTestOutputListener(TestOutputListener listener) {
        this.testOutputListenerSubscriptions.removeListener(listener);
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    private TestExceptionFormatter getExceptionFormatter(TestLogging testLogging) {
        switch (testLogging.getExceptionFormat()) {
            case SHORT: {
                return new ShortExceptionFormatter(testLogging);
            }
            case FULL: {
                return new FullExceptionFormatter(testLogging);
            }
        }
        throw new AssertionError();
    }

    public void onOutput(Closure closure) {
        this.addDispatchAsTestOutputListener("onOutput", closure);
    }

    public void beforeSuite(Closure closure) {
        this.addDispatchAsTestListener("beforeSuite", closure);
    }

    public void afterSuite(Closure closure) {
        this.addDispatchAsTestListener("afterSuite", closure);
    }

    public void beforeTest(Closure closure) {
        this.addDispatchAsTestListener("beforeTest", closure);
    }

    public void afterTest(Closure closure) {
        this.addDispatchAsTestListener("afterTest", closure);
    }

    @Nested
    public TestLoggingContainer getTestLogging() {
        return this.testLogging;
    }

    public void testLogging(@DelegatesTo(value=TestLoggingContainer.class) Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)this.testLogging);
    }

    public void testLogging(Action<? super TestLoggingContainer> action) {
        action.execute((Object)this.testLogging);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    @TaskAction
    public void executeTests() {
        LogLevel currentLevel = this.determineCurrentLogLevel();
        TestLogging levelLogging = this.getTestLogging().get(currentLevel);
        TestExceptionFormatter exceptionFormatter = this.getExceptionFormatter(levelLogging);
        TestEventLogger eventLogger = new TestEventLogger(this.getTextOutputFactory(), currentLevel, levelLogging, exceptionFormatter);
        this.addTestListener(eventLogger);
        this.addTestOutputListener(eventLogger);
        TestExecutionSpec executionSpec = this.createTestExecutionSpec();
        File binaryResultsDir = (File)this.getBinaryResultsDirectory().getAsFile().get();
        FileSystemOperations fs = this.getFileSystemOperations();
        fs.delete(spec -> spec.delete(new Object[]{binaryResultsDir}));
        try {
            Files.createDirectories(binaryResultsDir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        TestCountLogger testCountLogger = new TestCountLogger(this.getProgressLoggerFactory());
        this.addTestListener(testCountLogger);
        @NonNull AnonymousListenerBroadcast testListenerInternalBroadcaster = this.getListenerManager().createAnonymousBroadcaster(TestListenerInternal.class);
        testListenerInternalBroadcaster.add((Object)new TestListenerAdapter((TestListener)this.testListenerSubscriptions.get().getSource(), (TestOutputListener)this.testOutputListenerSubscriptions.get().getSource()));
        ProgressLogger parentProgressLogger = this.getProgressLoggerFactory().newOperation(AbstractTestTask.class);
        parentProgressLogger.setDescription("Test Execution");
        parentProgressLogger.started();
        TestWorkerProgressListener testWorkerProgressListener = new TestWorkerProgressListener(this.getProgressLoggerFactory(), parentProgressLogger);
        testListenerInternalBroadcaster.add((Object)testWorkerProgressListener);
        TestReportGenerator reportGenerator = this.createReportGenerator();
        try (TestEventReporterAsListener reporterAsListener = new TestEventReporterAsListener(arg_0 -> this.lambda$executeTests$2(reportGenerator, (ListenerBroadcast)testListenerInternalBroadcaster, arg_0));){
            TestExecuter testExecuter = (TestExecuter)Cast.uncheckedNonnullCast(this.createTestExecuter());
            TestListenerInternal resultProcessorDelegate = reporterAsListener;
            if (this.failFast) {
                resultProcessorDelegate = new FailFastTestListenerInternal(testExecuter, resultProcessorDelegate);
            }
            StateTrackingTestResultProcessor resultProcessor = new StateTrackingTestResultProcessor(resultProcessorDelegate);
            try {
                testExecuter.execute(executionSpec, resultProcessor);
            }
            finally {
                parentProgressLogger.completed();
                testWorkerProgressListener.completeAll();
                this.testListenerSubscriptions.removeAllListeners();
                this.testOutputListenerSubscriptions.removeAllListeners();
                testListenerInternalBroadcaster.removeAll();
            }
            TestEventReporterFactoryInternal.TestReportResult testReportResults = this.handleCollectedResults(testCountLogger);
            if (testReportResults.shouldFailTask()) {
                throw new MarkedVerificationException(testReportResults.getFailureMessage().orElseThrow(() -> new IllegalStateException("Failure must supply a failure message")));
            }
        }
    }

    private @Nullable TestReportGenerator createReportGenerator() {
        ArrayList<TestReportGenerator> reportGenerators = new ArrayList<TestReportGenerator>();
        DirectoryReport html = this.reports.getHtml();
        File outputLocation = ((Directory)html.getOutputLocation().get()).getAsFile();
        if (((Boolean)html.getRequired().get()).booleanValue()) {
            if (this.testReporter != null) {
                reportGenerators.add(new CustomTestReportingGenerator(outputLocation, this.testReporter));
            } else {
                reportGenerators.add((TestReportGenerator)this.getObjectFactory().newInstance(GenericHtmlTestReportGenerator.class, new Object[]{outputLocation.toPath()}));
            }
        } else {
            this.getLogger().info("Test report disabled, omitting generation of the HTML test report.");
        }
        JUnitXmlReport junitXml = this.reports.getJunitXml();
        if (((Boolean)junitXml.getRequired().get()).booleanValue()) {
            JUnitXmlResultOptions xmlResultOptions = new JUnitXmlResultOptions(junitXml.isOutputPerTestCase(), (Boolean)junitXml.getMergeReruns().get(), (Boolean)junitXml.getIncludeSystemOutLog().get(), (Boolean)junitXml.getIncludeSystemErrLog().get());
            reportGenerators.add((TestReportGenerator)this.getObjectFactory().newInstance(JunitXmlTestReportGenerator.class, new Object[]{((Directory)junitXml.getOutputLocation().get()).getAsFile().toPath(), xmlResultOptions}));
        }
        if (reportGenerators.isEmpty()) {
            return null;
        }
        if (reportGenerators.size() == 1) {
            return (TestReportGenerator)reportGenerators.get(0);
        }
        return new MultiTestReportGenerator((TestReportGenerator)reportGenerators.get(0), (Set<TestReportGenerator>)ImmutableSet.copyOf(reportGenerators.subList(1, reportGenerators.size())));
    }

    private TestEventReporterFactoryInternal.TestReportResult handleCollectedResults(TestCountLogger testCountLogger) {
        if (testCountLogger.hadFailures()) {
            if (testCountLogger.hasWorkerFailures()) {
                return testCountLogger.handleWorkerFailures();
            }
            return this.handleTestFailures();
        }
        if (testCountLogger.getTotalTests() == 0L) {
            if (this.testsAreNotFiltered()) {
                if (testCountLogger.getTotalDiscoveredItems() == 0L && ((Boolean)this.getFailOnNoDiscoveredTests().get()).booleanValue()) {
                    return TestEventReporterFactoryInternal.TestReportResult.noTestsRun("There are test sources present and no filters are applied, but the test task did not discover any tests to execute. This is likely due to a misconfiguration. Please check your test configuration. If this is not a misconfiguration, this error can be disabled by setting the 'failOnNoDiscoveredTests' property to false.");
                }
            } else if (this.shouldFailOnNoMatchingTests()) {
                return TestEventReporterFactoryInternal.TestReportResult.noTestsRun(this.createNoMatchingTestErrorMessage());
            }
        }
        return TestEventReporterFactoryInternal.TestReportResult.noAction();
    }

    private boolean shouldFailOnNoMatchingTests() {
        return this.patternFiltersSpecified() && this.filter.isFailOnNoMatchingTests();
    }

    boolean testsAreNotFiltered() {
        return !this.patternFiltersSpecified();
    }

    private boolean patternFiltersSpecified() {
        return !this.filter.getIncludePatterns().isEmpty() || !this.filter.getCommandLineIncludePatterns().isEmpty() || !this.filter.getExcludePatterns().isEmpty();
    }

    private String createNoMatchingTestErrorMessage() {
        return "No tests found for given includes: " + Joiner.on((char)' ').join(this.getNoMatchingTestErrorReasons());
    }

    @Internal
    protected List<String> getNoMatchingTestErrorReasons() {
        ArrayList<String> reasons = new ArrayList<String>();
        if (!this.getFilter().getIncludePatterns().isEmpty()) {
            reasons.add(this.getFilter().getIncludePatterns() + "(filter.includeTestsMatching)");
        }
        if (!this.filter.getCommandLineIncludePatterns().isEmpty()) {
            reasons.add(this.filter.getCommandLineIncludePatterns() + "(--tests filter)");
        }
        return reasons;
    }

    @Option(option="tests", description="Sets test class or method name to be included (in addition to the test task filters), '*' is supported.")
    public AbstractTestTask setTestNameIncludePatterns(List<String> testNamePattern) {
        this.filter.setCommandLineIncludePatterns(testNamePattern);
        return this;
    }

    @Internal
    boolean getFailFast() {
        return this.failFast;
    }

    void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    @Nested
    public TestTaskReports getReports() {
        return this.reports;
    }

    public TestTaskReports reports(Closure closure) {
        return this.reports((Action)new ClosureBackedAction(closure));
    }

    public TestTaskReports reports(Action<? super TestTaskReports> configureAction) {
        configureAction.execute((Object)this.reports);
        return this.reports;
    }

    @Nested
    public TestFilter getFilter() {
        return this.filter;
    }

    @Input
    public abstract Property<Boolean> getFailOnNoDiscoveredTests();

    private TestEventReporterFactoryInternal.TestReportResult handleTestFailures() {
        String message = this.buildFailureResultsMessage("There were failing tests.");
        if (this.getIgnoreFailures()) {
            this.getLogger().warn(message);
            return TestEventReporterFactoryInternal.TestReportResult.failuresIgnored();
        }
        return TestEventReporterFactoryInternal.TestReportResult.testFailureDetected(message);
    }

    private String buildFailureResultsMessage(String message) {
        DirectoryReport htmlReport = this.getReports().getHtml();
        if (((Boolean)htmlReport.getRequired().get()).booleanValue()) {
            String reportUrl = new ConsoleRenderer().asClickableFileUrl(htmlReport.getEntryPoint());
            message = message.concat(" See the report at: " + reportUrl);
        } else {
            JUnitXmlReport junitXmlReport = this.getReports().getJunitXml();
            if (((Boolean)junitXmlReport.getRequired().get()).booleanValue()) {
                String resultsUrl = new ConsoleRenderer().asClickableFileUrl(junitXmlReport.getEntryPoint());
                message = message.concat(" See the results at: " + resultsUrl);
            }
        }
        return message;
    }

    private /* synthetic */ GroupTestEventReporterInternal lambda$executeTests$2(TestReportGenerator reportGenerator, ListenerBroadcast testListenerInternalBroadcaster, TestDescriptorInternal descriptor) {
        return ((TestEventReporterFactoryInternal)this.getTestEventReporterFactory()).createInternalTestEventReporter(ignored -> descriptor, (Directory)this.getBinaryResultsDirectory().get(), reportGenerator, (ListenerBroadcast<TestListenerInternal>)testListenerInternalBroadcaster, this.getReportEntrySkipLevels(), false);
    }

    private class BroadcastSubscriptions<T> {
        private final Class<T> listenerClass;
        private final List<Object> subscribedListeners = new LinkedList<Object>();
        private transient ListenerBroadcast<T> broadcaster;

        private BroadcastSubscriptions(Class<T> listenerClass) {
            this.listenerClass = listenerClass;
        }

        ListenerBroadcast<T> get() {
            if (this.broadcaster == null) {
                this.broadcaster = AbstractTestTask.this.getListenerManager().createAnonymousBroadcaster(this.listenerClass);
                for (Object listener : this.subscribedListeners) {
                    if (this.listenerClass.isInstance(listener)) {
                        this.broadcaster.add(listener);
                        continue;
                    }
                    this.broadcaster.add((Dispatch)listener);
                }
            }
            return this.broadcaster;
        }

        void addListener(T listener) {
            this.subscribedListeners.add(listener);
            if (this.broadcaster != null) {
                this.broadcaster.add(listener);
            }
        }

        void addListener(Dispatch<MethodInvocation> listener) {
            this.subscribedListeners.add(listener);
            if (this.broadcaster != null) {
                this.broadcaster.add(listener);
            }
        }

        void removeListener(Object listener) {
            this.subscribedListeners.remove(listener);
            if (this.broadcaster != null) {
                this.broadcaster.remove(listener);
            }
        }

        void removeAllListeners() {
            this.subscribedListeners.clear();
            if (this.broadcaster != null) {
                this.broadcaster.removeAll();
            }
        }
    }

    @NullMarked
    private static final class CustomTestReportingGenerator
    implements TestReportGenerator {
        private final File outputDir;
        private final TestReporter testReporter;

        private CustomTestReportingGenerator(File outputDir, TestReporter testReporter) {
            this.outputDir = outputDir;
            this.testReporter = testReporter;
        }

        @Override
        public Path generate(List<Path> resultsDirectories) {
            if (resultsDirectories.size() > 1) {
                throw new IllegalArgumentException("CustomTestReportingGenerator can only generate a report from a single results directory. Found: " + resultsDirectories);
            }
            TestTreeModelResultsProvider.useResultsFrom(resultsDirectories.get(0), resultsProvider -> this.testReporter.generateReport((TestResultsProvider)resultsProvider, this.outputDir));
            return this.outputDir.toPath();
        }
    }
}

