/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal.install;

import java.io.File;
import java.net.URI;
import org.gradle.api.GradleException;
import org.gradle.internal.FileUtils;
import org.gradle.internal.SafeFileLocationUtils;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.LocalBinaryResource;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.install.exceptions.ToolchainDownloadException;
import org.gradle.jvm.toolchain.internal.install.exceptions.ToolchainProvisioningException;

@ServiceScope(value={Scope.Build.class})
public interface JavaToolchainProvisioningService {
    public File tryInstall(JavaToolchainSpec var1) throws ToolchainDownloadException, ToolchainProvisioningException;

    default public boolean isAutoDownloadEnabled() {
        return true;
    }

    default public boolean hasConfiguredToolchainRepositories() {
        return true;
    }

    default public String getFileName(URI uri, ExternalResource resource) {
        String fileName;
        if (resource instanceof LocalBinaryResource && (fileName = ((LocalBinaryResource)resource).getBaseName()) != null) {
            return fileName;
        }
        ExternalResourceMetaData metaData = resource.getMetaData();
        if (metaData == null) {
            throw ResourceExceptions.getMissing((URI)uri);
        }
        String fileName2 = metaData.getFilename();
        if (fileName2 == null) {
            throw new GradleException("Can't determine filename for resource located at: " + uri);
        }
        return fileName2;
    }

    default public String buildFileNameWithDetails(URI uri, ExternalResource resource, JavaToolchainSpec spec) {
        String originalFileName = this.getFileName(uri, resource);
        String id = SafeFileLocationUtils.toSafeFileName((String)("-" + spec.getVendor().get() + '-' + ((JavaLanguageVersion)spec.getLanguageVersion().get()).asInt()));
        return FileUtils.addSuffixToName((String)originalFileName, (String)id);
    }
}

