/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.tooling.Failure;
import org.gradle.tooling.FetchModelResult;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.connection.StreamingAwareBuildControllerAdapter;
import org.gradle.tooling.internal.consumer.parameters.BuildProgressListenerAdapter;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.InternalBuildControllerVersion2;
import org.gradle.tooling.internal.protocol.InternalFetchModelResult;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.internal.protocol.resiliency.InternalFetchAwareBuildController;
import org.gradle.tooling.model.Model;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
class FetchAwareBuildControllerAdapter
extends StreamingAwareBuildControllerAdapter {
    private final InternalFetchAwareBuildController fetch;

    public FetchAwareBuildControllerAdapter(InternalBuildControllerVersion2 buildController, ProtocolToModelAdapter adapter, ModelMapping modelMapping, VersionDetails gradleVersion, File rootDir) {
        super(buildController, adapter, modelMapping, gradleVersion, rootDir);
        this.fetch = (InternalFetchAwareBuildController)((Object)buildController);
    }

    @Override
    public <T extends Model, M, P> FetchModelResult<T, M> fetch(@Nullable T target, Class<M> modelType, @Nullable Class<P> parameterType, @Nullable Action<? super P> parameterInitializer) {
        Object originalTarget = this.unpackModelTarget(target);
        ModelIdentifier modelIdentifier = this.getModelIdentifierFromModelType(modelType);
        Object parameter = parameterInitializer != null ? FetchAwareBuildControllerAdapter.initializeParameter(parameterType, parameterInitializer) : null;
        InternalFetchModelResult<Object> result = this.fetch.fetch(originalTarget, modelIdentifier, parameter);
        return this.adaptResult(target, modelType, result);
    }

    private <T extends Model, M> FetchModelResult<T, M> adaptResult(@Nullable T target, Class<M> modelType, InternalFetchModelResult<Object> result) {
        Object model = result.getModel();
        Object adaptedModel = model != null ? (Object)this.adaptModel(target, modelType, model) : null;
        return new ModelFetchModelResult<T, Object>(result, adaptedModel, target);
    }

    private static class ModelFetchModelResult<T extends Model, M>
    implements FetchModelResult<T, M>,
    Serializable {
        private final InternalFetchModelResult<Object> result;
        private final M adaptedModel;
        private final T target;
        @Nullable List<Failure> failures;

        public ModelFetchModelResult(InternalFetchModelResult<Object> result, M adaptedModel, T target) {
            this.result = result;
            this.adaptedModel = adaptedModel;
            this.target = target;
            this.failures = null;
        }

        @Override
        public T getTarget() {
            return this.target;
        }

        @Override
        public M getModel() {
            return this.adaptedModel;
        }

        @Override
        public Collection<? extends Failure> getFailures() {
            if (this.failures == null) {
                this.failures = BuildProgressListenerAdapter.toFailures(this.result.getFailures());
            }
            return this.failures;
        }
    }
}

